package com.pangding.web.authority.feign;

import com.pangding.web.authority.vo.reqvo.CompanyBankReqVo1;
import com.pangding.web.authority.vo.reqvo.CompanyReqVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.req.company.SaveCompanyReqVo;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/6/2 18:06
 */
@FeignClient(value="pd-interface-pay")
@RequestMapping(value="/userNew")
public interface PayFeign {
    /**
     * 注册会员
     * @param req
     * @return
     */
    @RequestMapping(value="/register")
    ResponseResult<CompanyReqVo> setCompanyInfo(@RequestBody CompanyReqVo req);

    @RequestMapping(value = "/setCompanyInfo", method = RequestMethod.POST)
    ResponseResult<SaveCompanyReqVo> setCompanyInfo1(@RequestBody SaveCompanyReqVo req);

    /**
     * 绑定银行卡
     * @param req
     * @return
     */
    @RequestMapping(value="/bindback")
    ResponseResult<CompanyBankCardReqVo> bindBack(@RequestBody CompanyBankCardReqVo req);

    /**
     * 解绑银行卡
     * @param req
     * @return
     */
    @RequestMapping(value = "/unbindBankCard")
    ResponseResult<CompanyBankCardReqVo> unbindBankCard(@RequestBody CompanyBankCardReqVo req);

    /**
     * 获取签约地址
     * @param req
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/sign")
    ResponseResult<CompanyReqVo> sign(@RequestBody CompanyReqVo req) throws IOException;
}
