package com.pangding.web.authority.mq;

import com.pangding.web.mq.CompanyProducer;
import com.pangding.web.mq.DistributionProducer;
import com.pangding.web.mq.OrderProducer;
import com.pangding.web.mq.PayProducer;
import com.yanzuoguang.mq.service.MqService;
import com.yanzuoguang.util.thread.ThreadNext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 消息队列初始化服务，用于重启时，初始化消息队列对象
 *
 * @author 11488
 */
@Component
public class MqPlan implements ThreadNext.Next {

    @Autowired
    private MqService mqService;
    @Autowired
    private CompanyProducer companyProducer;


    public MqPlan() {
        ThreadNext.start(this, "queue initByLog error");
    }

    @Override
    public boolean next() throws Exception {
        if (mqService == null  || null == companyProducer) {
            return true;
        }
        companyProducer.init();
        return false;
    }

    @Override
    public int getNextTime() {
        return 1000;
    }

    public void init() {
        try {
            this.next();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
