package com.pangding.web.authority.controller;


import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/newCompany")
public class CompanyCtroller {

    @Autowired
    private CompanyService companyService;

    /**
     * 找到公司余额
     * @param req
     * @return
     */
    @RequestMapping(value = "/findCompanyBalance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult findCompanyBalance(@RequestBody CompanyReqVo req){
        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return ResponseResult.result(companyService.findCompanyBalance(req));
    }



}
