package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.UserVo;
import com.pangding.web.authority.vo.reqvo.AddReqVo;
import com.pangding.web.authority.vo.reqvo.CountByRoleReqVo;
import com.pangding.web.authority.vo.reqvo.ListRoleReqVo;
import com.pangding.web.authority.vo.reqvo.WebRoleReqVo;
import com.pangding.web.authority.vo.resvo.WebRoleResVo;
import com.pangding.web.vo.system.pd.authority.AuthorityVo;
import com.pangding.web.vo.system.pd.authority.RoleVo;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleService {

    /**
     * 保存RoleVo对象,并保存角色权限的对应关系
     *
     * @param webRoleReqVo
     * @return 返回角色id
     */
    String saveRole(WebRoleReqVo webRoleReqVo);

    /**
     * 更新RoleVo对象,并更新角色权限的对应关系
     *
     * @param webRoleReqVo RoleDto对象
     * @return 返回角色id
     */
    String updateRole(WebRoleReqVo webRoleReqVo);

    /**
     * 通过主键id查询RoleVo对象
     *
     * @param webRoleReqVo 主键
     * @return RoleVo对象
     */
    WebRoleResVo getRoleById(WebRoleReqVo webRoleReqVo);

    /**
     * 检查角色名是否已存在
     *
     * @param roleVo RoleVo对象
     */
    void checkNameExist(RoleVo roleVo);

    /**
     * 获取角色返回信息
     *
     * @param req
     * @return 角色返回信息
     */
    List<WebRoleResVo> getWebRoleResVoList(ListRoleReqVo req);

    /**
     * 获取该公司该角色已分配的角色列表
     * @param reqVo 封装了公司id和权限id的请求对象
     * @return 用户列表
     */
    List<UserVo> count(CountByRoleReqVo reqVo);

    /**
     * 通过角色id查询该角色权限id列表
     *
     * @param roleId 角色id
     * @return 权限id列表
     */
    List<AuthorityVo> getAuthorityListByRoleId(String roleId);

    /**
     * 通过权限id查询权限名
     *
     * @param authorityId 权限id
     * @return 权限名
     */
    String getAuthorityNameByAuthorityId(String authorityId);

    /**
     * 将RoleVo对象添加权限ID列表和权限名列表封装成RoleDto对象
     *
     * @param roleVo RoleVo对象
     * @param authorityList 权限列表
     * @return RoleDto对象
     */
    WebRoleResVo makeResVo(RoleVo roleVo, List<AuthorityVo> authorityList);

    /**
     * 删除角色，并删除角色和用户的对应关系以及角色和权限的对应关系
     *
     * @param roleVo RoleVo对象
     */
    void deleteRole(RoleVo roleVo);

    /**
     * 删除角色信息
     *
     * @param webRoleReqVo
     */
    void delete(WebRoleReqVo webRoleReqVo);

    /**
     * 获取该公司该角色已分配的角色列表
     * @param reqVo 封装了公司id和权限id的请求对象
     * @return 用户列表
     */
    PageSizeData<UserVo> countByRole(CountByRoleReqVo reqVo);

    void add(AddReqVo reqVo);
}
