# 参数请符合实体，而不是单独的参数,专注于参数内容，专注于参数顺序
``` java 
{
  id: "1"
}
```
如:
```java 
public List<String> getRoleTrightPKListByRoleId(String roleId) {
    return this.query(String.class,GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,roleId);
}
```


# RoleDaoImpl
## 夏敏的函数请用load，可以删除
``` java 
@Override
public RoleVo getRoleById(String id) {
    return this.queryFirst(RoleVo.class,GET_ROLE_BY_ID,id);
}

@Override
public RoleVo getRoleByName(String name) {
    return this.queryFirst(RoleVo.class,GET_ROLE_BY_NAME,name);
}
```
参见如下代码:
``` java 
dao.load({id:"1"})
dao.load({name:"1"})
```

## 检测语句
``` java 
table.add(CHECK_NAME_EXIST,"select count(r.id) from pd_role r where 1=1 ")
.add("name","and r.name = ? ")
.add("id","and r.id <> ?");
```
改成
```java 
table.addExist(CHECK_NAME_EXIST,"name");
```
调用时
``` java 
this.checkExist(CHECK_NAME_EXIST,roleVo,"橘色名称已经存在");
```

# 请确定语句主表，比如说和 pd_role_authority表和pd_authority表的查询，请另外新建dao层，符合三层架构规范
``` java 

table.add(GET_TRIGHTID_LIST,"select authority_id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");

table.add(GET_TRIGHTNAME_BY_TRIGHTID,"select name from pd_authority where 1=1 ")
.add("trightId","and id = ?");

```

# ＳＱＬ语句合并
```java 
table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");

table.add(GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID,"select id from pd_role_authority where 1=1 ")
.add("trightId","and tright_id = ?");
```
可以合并为
```java 

table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");
.add("trightId","and tright_id = ?");
```

# 更爱ＳＱＬ语句
```java 
 table.add(CHECK_VALID,"select count(a.id) from pd_authority a where 1=1 ")
        .add("name","and a.name = ? ")
        .add("url","and a.url = ? ")
        .add("id","and a.id <> ?");
```
改为:
``` java 
table.addExist(CHECK_VALID,"name","url");
```

# 将如下ＳＱＬ语句合并
``` java
table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
.add("id","and id = ?");

table.add(LIST_ALL,"select * from pd_authority where 1=1");

table.add(LIST_LEVEL_ONE,"select * from pd_authority where pid=null");
// 这句ＳＱＬ语句可以去掉，本身没有意义
table.add(CHECK_CHILD,"select count(id) from pd_authority where 1=1 ")
.add("id","and pid = ?");

table.add(GET_CHILDID_LIST,"select id from pd_authority where 1=1 ")
.add("id","and pid = ?");
```
如:
is null, is not null , ifnull(field,'')=''
```java 
table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
.add("id","and id = ?")
.add("top","and ifnull(pid,'')= ''")
.add("pid","and pid = ?");
```

# 将如下ＳＱＬ语句合并
``` java
table.add(GET_USER, "SELECT  id,account,phone,status,remark,create_time,creator FROM pd_user  WHERE 1=1 ")
        .add("account", " AND account = ?");

table.add(GET_ALL_USERS,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1");

table.add(GET_ROLE_IDS,"select role_id from pd_user_role where 1=1 ")
        .add("userId","and user_id = ?");

table.add(GET_USER_BY_ID,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1 ")
        .add("userId","and user_id = ?");

table.add(GET_ROLE_BY_ROLEID,"select name from pd_role where 1=1 ")
        .add("roleId","and id = ?");
```

# 如下语句可以删除
``` java
table.add(DELETE_USER_ROLE,"delete from pd_user_role_relation where 1=1 ")
        .add("userId","and user_id = ?");
```
直接调用:
``` 
dao.remove({userId:"1"})
```