package com.pangding.web.authority.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * 权限表
 * @author zhangjinyao
 */
@TableAnnotation("pd_authority")
public class AuthorityVo implements Serializable, InitDao {

    private String id;

    private String pid;

    private String name;

    private String type;

    private String alias;

    private String url;

    @TableAnnotation("open_mode")
    private String openMode;

    private String remark;

    @TableAnnotation("create_time")

    private String createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOpenMode() {
        return openMode;
    }

    public void setOpenMode(String openMode) {
        this.openMode = openMode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @Override
    public void init() {
        this.createTime = StringHelper.getFirst(this.createTime, DateHelper.getNow());
    }
}
