package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.reqvo.AuthorityGetReqVo;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityReqVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface AuthorityDao extends BaseDao {

    /**
     * 检查新建或修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     */
    void checkValid(AuthorityVo authorityVo);

    /**
     * 根据主键获取authorityVo对象
     *
     * @param authorityGetReqVo 主键
     * @return authorityVo对象
     */
    AuthorityVo getAuthority(AuthorityGetReqVo authorityGetReqVo);

    PageSizeData<AuthorityVo> getAuthorityList(ListAuthorityReqVo reqVo);

    List<AuthorityVo> getAuthoritys(AuthorityGetReqVo reqVo);

}
