package com.pangding.web.authority.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 14:35
 */
@TableAnnotation("pd_merchant")
public class MerchantVo implements Serializable, InitDao {
    private String id;

    private String code;

    private String name;

    private String longitude;

    private String latitude;

    private String score;

    @TableAnnotation("area_code")
    private String areaCode;

    @TableAnnotation("area_name")
    private String areaName;

    private String address;

    private int attribute;

    private String tag;

    private String level;

    private int status;

    @TableAnnotation("time_spent")
    private String timeSpent;

    private String phone;

    @TableAnnotation("the_provider")
    private String theProvider;

    @TableAnnotation("the_interface")
    private String theInterface;

    @TableAnnotation("business_start")
    private String businessStart;

    @TableAnnotation("business_end")
    private String businessEnd;

    @TableAnnotation("create_time")
    private String createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getAttribute() {
        return attribute;
    }

    public void setAttribute(int attribute) {
        this.attribute = attribute;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getTimeSpent() {
        return timeSpent;
    }

    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getTheProvider() {
        return theProvider;
    }

    public void setTheProvider(String theProvider) {
        this.theProvider = theProvider;
    }

    public String getTheInterface() {
        return theInterface;
    }

    public void setTheInterface(String theInterface) {
        this.theInterface = theInterface;
    }

    public String getBusinessStart() {
        return businessStart;
    }

    public void setBusinessStart(String businessStart) {
        this.businessStart = businessStart;
    }

    public String getBusinessEnd() {
        return businessEnd;
    }

    public void setBusinessEnd(String businessEnd) {
        this.businessEnd = businessEnd;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @Override
    public void init() {
        this.createTime = StringHelper.getFirst(this.createTime, DateHelper.getNow());
    }
}
