package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.feign.DataFeign;
import com.pangding.web.authority.service.DataService;
import com.pangding.web.authority.util.CompanyConstant;
import com.pangding.web.authority.util.RoleConstant;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.FindResVo;
import com.pangding.web.authority.vo.resvo.OrderResVo;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author zhangjinyao
 * @create 2019/6/12 15:45
 */
@Service
public class DataServiceImpl implements DataService {
    @Autowired
    private CompanyDao companyDaoImpl;
    @Autowired
    private UserDao userDaoImpl;
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDaoImpl;
    @Autowired
    private UserRoleDao userRoleDaoImpl;
    @Autowired
    private OrderDao orderDaoImpl;
    @Autowired
    private OrderExtendDao orderExtendDaoImpl;
    @Autowired
    private OrderRefundDao orderRefundDaoImpl;
    @Autowired
    private OrderStatusDao orderStatusDaoImpl;
    @Autowired
    private OrderTicketDetailDao orderTicketDetailDao;
    @Autowired
    private OrderTouristDao orderTouristDao;
    @Autowired
    private DiscountDetailDao discountDetailDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(FindResVo reqVo) {

        TyyCompanyVo tyyCompanyVo = reqVo.getTyyCompanyVo();
        TyyCompanyExtendVo tyyCompanyExtendVo = reqVo.getTyyCompanyExtendVo();
        EnterpriseVo enterpriseVo = reqVo.getEnterpriseVo();
        List<EnterpriseBankVo> enterpriseBankVoList = reqVo.getEnterpriseBankVoList();

        /*保存公司主表*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(tyyCompanyVo.getId());
        companyVo.setPid(tyyCompanyVo.getPid());
        companyVo.setInvitationCompanyId(tyyCompanyVo.getInvatationId());
        companyVo.setNature(tyyCompanyVo.getCompanyType());
        if (tyyCompanyVo.getCompanyType() == 1 || tyyCompanyVo.getCompanyType() == 2){
            companyVo.setCompanyType(1);
        }else if (tyyCompanyVo.getCompanyType() == 3){
            companyVo.setCompanyType(0);
        }
        companyVo.setCompanyName(tyyCompanyVo.getCompanyName());
        companyVo.setAddress(tyyCompanyVo.getCompanyAddress());
        companyVo.setBusinessLicenseCode(tyyCompanyVo.getCompanyCardNo());
        companyVo.setContactName(tyyCompanyVo.getContactName());
        companyVo.setContactCode(tyyCompanyVo.getContactNo());
        companyVo.setContactPhone(tyyCompanyVo.getContactTel());
        companyVo.setStatus(tyyCompanyVo.getStatus());
        companyVo.setCreateTime(tyyCompanyVo.getCreateTime());
        companyVo.setExamineStatus(Integer.parseInt(enterpriseVo.getExamine()));
        companyVo.setCompanyAttribute(Integer.parseInt(enterpriseVo.getUsertype()));
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        if (null != tyyCompanyExtendVo ){
            companyVo.setElectromicAgreementCode(tyyCompanyExtendVo.getCode());
            companyVo.setSigningStatus(tyyCompanyExtendVo.getStatus());
        }
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(companyVo.getId());
        CompanyVo companyVo1 = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        if (null == companyVo1){
            companyDaoImpl.create(companyVo);
        }else{
            companyDaoImpl.update(companyVo);
        }

        /*保存用户表*/
        UserVo userVo = new UserVo();
        userVo.setId(StringHelper.getNewID());
        userVo.setCompanyId(enterpriseVo.getId());
        userVo.setAccount(enterpriseVo.getAccount());
        userVo.setPassword(enterpriseVo.getPasswd());
        userVo.setRemark(enterpriseVo.getPlainPassword());
        userVo.setName(tyyCompanyVo.getContactName());
        userVo.setPhone(tyyCompanyVo.getContactTel());
        userVo.setCreateTime(tyyCompanyVo.getCreateTime());
        userVo.setEmail(enterpriseVo.getEmail());
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(userVo.getAccount());
        UserVo userVo1 = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null == userVo1){
            userDaoImpl.create(userVo);
            /*给用户分配管理员角色*/
            UserRoleVo userRoleVo = new UserRoleVo();
            userRoleVo.setUserId(userVo.getId());
            userRoleVo.setRoleId(RoleConstant.ADMIN_ROLE_ID);
            userRoleDaoImpl.create(userRoleVo);
        }else{
            userVo.setId(userVo1.getId());
            userDaoImpl.update(userVo);
            /*给用户分配管理员角色*/
            UserRoleVo userRoleVo = new UserRoleVo();
            userRoleVo.setUserId(userVo1.getId());
            userRoleVo.setRoleId(RoleConstant.ADMIN_ROLE_ID);
            UserRoleVo userRoleVo1 = userRoleDaoImpl.load(userRoleVo,UserRoleVo.class);
            if (null == userRoleVo1){
                userRoleVo.setId(StringHelper.getNewID());
                userRoleDaoImpl.create(userRoleVo);
            }
        }

        /*保存公司扩展表*/
        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        companyExtendVo.setId(tyyCompanyVo.getId());
        companyExtendVo.setQrCodeUrl(enterpriseVo.getQrcodepath());
        companyExtendVo.setQrCode(enterpriseVo.getQrcodesrc());
        companyExtendVo.setInvitationCode(enterpriseVo.getInvitationCode());
        companyExtendVo.setDivedeStatus(Integer.parseInt(enterpriseVo.getIsShare()));
        if (null != tyyCompanyExtendVo ){
            companyExtendVo.setWithdrawTotalCash(tyyCompanyExtendVo.getMoney());
        }
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(companyExtendVo.getId());
        CompanyExtendVo companyExtendVo1 = companyExtendDaoImpl.load(companyExtendGetReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo1){
            companyExtendDaoImpl.create(companyExtendVo);
        }else{
            companyExtendDaoImpl.update(companyExtendVo);
        }

        /*保存银行卡表*/
        Boolean flag = true;
        for (EnterpriseBankVo enterpriseBankVo:enterpriseBankVoList) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            companyBankCardVo.setId(enterpriseBankVo.getId());
            companyBankCardVo.setName(enterpriseBankVo.getName());
            companyBankCardVo.setBankCardCode(enterpriseBankVo.getBanknum());
            companyBankCardVo.setBankName(enterpriseBankVo.getBankname());
            companyBankCardVo.setType(enterpriseBankVo.getType());
            companyBankCardVo.setCompanyId(enterpriseBankVo.getEnterpriseid());
            companyBankCardVo.setBankAddress(enterpriseBankVo.getAddr());
            companyBankCardVo.setPhone(enterpriseBankVo.getPhone());
            companyBankCardVo.setIdCard(enterpriseBankVo.getIdcard());
            companyBankCardVo.setBankCode(enterpriseBankVo.getUnionBank());
            companyBankCardVo.setStatus(enterpriseBankVo.getBankStatus());
            companyBankCardVo.setBindingCode(enterpriseBankVo.getBindId());
            companyBankCardVo.setBindingTime(enterpriseBankVo.getBindDate());
            if (flag){
                companyBankCardVo.setIsDefault(1);
                flag = false;
            }
            CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
            companyBankCardGetReqVo.setId(companyBankCardVo.getId());
            CompanyBankCardVo companyBankCardVo1 = companyBankCardDaoImpl.load(companyBankCardGetReqVo,CompanyBankCardVo.class);
            if (null == companyBankCardVo1){
                companyBankCardDaoImpl.create(companyBankCardVo);
            }else{
                companyBankCardDaoImpl.update(companyBankCardVo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrderStepTwo(OrderResVo reqVo) {
        TyyOrdersVo tyyOrdersVo = reqVo.getTyyOrdersVo();
        List<TyyOrderbackVo> tyyOrderbackVoList = reqVo.getTyyOrderbackVoList();
        TyyOrderdetailsVo tyyOrderdetailsVo = reqVo.getTyyOrderdetailsVo();
        TyyTouristVo tyyTouristVo = reqVo.getTyyTouristVo();
        /*OrderVo表*/
        int refundNum = 0;
        double refundFee = 0d;
        double pdRefundMoney = 0d;
        double refundMoney = 0d;
        for (TyyOrderbackVo tyyOrderbackVo:tyyOrderbackVoList) {
            refundNum += tyyOrderbackVo.getRefundnum();
            refundFee += tyyOrderbackVo.getRefundFee();
            pdRefundMoney += tyyOrderbackVo.getReceiveMoney();
            refundMoney += tyyOrderbackVo.getRefundMoney();
        }
        OrderVo orderVo = new OrderVo();
        orderVo.setId(tyyOrdersVo.getOrdersn());
        orderVo.setProduct_name(tyyOrdersVo.getConsignee());
        orderVo.setMerchant_name(tyyOrdersVo.getScenicspotname());
        orderVo.setProduct_code(tyyOrdersVo.getProductsn());
        orderVo.setRefund_num(refundNum);
        orderVo.setOrder_num(tyyOrdersVo.getBuynum());
        orderVo.setUnit_price(tyyOrdersVo.getPrice());
        orderVo.setTotal_money(tyyOrdersVo.getTotal());
        orderVo.setPlay_date(tyyOrdersVo.getTraveldate());
        orderVo.setOrder_time(tyyOrdersVo.getOrdertime());
        orderVo.setUser_id(tyyOrdersVo.getMemberid());
        orderVo.setTicket_phone(tyyOrdersVo.getUsertel());
        orderVo.setCost_price(tyyOrdersVo.getPurchaseprice());
        orderVo.setCost_total_money(tyyOrdersVo.getPurchaseprice()*tyyOrdersVo.getBuynum());
        orderVo.setOrder_money(orderVo.getCost_total_money()-tyyOrdersVo.getDiscountprice());
        orderVo.setRefund_fee(refundFee);
        orderVo.setPd_refund_money(pdRefundMoney);
        orderVo.setDiscount_money(tyyOrdersVo.getDiscountprice());
        orderVo.setPd_discount_money(tyyOrdersVo.getDiscountprice());
        orderVo.setRefund_money(refundMoney);
        orderVo.setSub_order_type(tyyOrdersVo.getFieldTicket());
        orderVo.setPd_order_money(tyyOrdersVo.getRealprice());
        orderVo.setArea_code(tyyOrdersVo.getSight_spot_code());
        orderVo.setOrder_type(1);
        /*若该id存在则跳过，不存在则新增*/
        OrderGetReqVo orderGetReqVo = new OrderGetReqVo();
        orderGetReqVo.setId(orderVo.getId());
        OrderVo orderVo1 = orderDaoImpl.load(orderGetReqVo,OrderVo.class);
        if (null == orderVo1){
            orderDaoImpl.create(orderVo);
        }
        /*OrderExtendVo表*/
        /*游玩地址*/
        OrderExtendVo orderExtendVoAddress = new OrderExtendVo();
        orderExtendVoAddress.setId(StringHelper.getNewID());
        orderExtendVoAddress.setOrder_id(tyyOrdersVo.getOrdersn());
        orderExtendVoAddress.setTitle("游玩地址");
        orderExtendVoAddress.setContent(tyyOrdersVo.getPlay_address());
        OrderExtendGetReqVo orderExtendGetReqVo = new OrderExtendGetReqVo();
        orderExtendGetReqVo.setOrder_id(orderExtendVoAddress.getOrder_id());
        orderExtendGetReqVo.setTitle(orderExtendVoAddress.getTitle());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderExtendVo orderExtendVo1 = orderExtendDaoImpl.load(orderExtendGetReqVo,OrderExtendVo.class);
        if (null == orderExtendVo1){
            orderExtendDaoImpl.create(orderExtendVoAddress);
        }
        /*OrderExtendVo表*/
        /*游玩时间*/
        OrderExtendVo orderExtendVoTime = new OrderExtendVo();
        orderExtendVoTime.setId(StringHelper.getNewID());
        orderExtendVoTime.setOrder_id(tyyOrdersVo.getOrdersn());
        orderExtendVoTime.setTitle("游玩时间");
        orderExtendVoTime.setContent(tyyOrdersVo.getPlay_time());
        OrderExtendGetReqVo orderExtendGetReqVo1 = new OrderExtendGetReqVo();
        orderExtendGetReqVo1.setOrder_id(orderExtendVoTime.getOrder_id());
        orderExtendGetReqVo1.setTitle(orderExtendVoTime.getTitle());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderExtendVo orderExtendVo2 = orderExtendDaoImpl.load(orderExtendGetReqVo,OrderExtendVo.class);
        if (null == orderExtendVo2){
            orderExtendDaoImpl.create(orderExtendVoTime);
        }
        /*OrderRefundVo表*/
        for (TyyOrderbackVo tyyOrderbackVo:tyyOrderbackVoList) {
            OrderRefundVo orderRefundVo = new OrderRefundVo();
            orderRefundVo.setId(tyyOrderbackVo.getId());
            orderRefundVo.setOrder_id(tyyOrderbackVo.getOrdersn());
            orderRefundVo.setOperator(tyyOrderbackVo.getAcceptanceuser());
            orderRefundVo.setRefund_status(tyyOrderbackVo.getRefundstatus());
            orderRefundVo.setRefund_date(tyyOrderbackVo.getRefundtime());
            orderRefundVo.setRefund_fee(tyyOrderbackVo.getRefundFee());
            orderRefundVo.setRefund_amount(tyyOrderbackVo.getReceiveMoney());
            orderRefundVo.setRefund_reason(tyyOrderbackVo.getRefundReason());
            /*若该id存在则跳过,不存在则新增*/
            OrderRefundGetReqVo orderRefundGetReqVo = new OrderRefundGetReqVo();
            orderRefundGetReqVo.setId(orderRefundVo.getId());
            OrderRefundVo orderRefundVo1 = orderRefundDaoImpl.load(orderRefundGetReqVo,OrderRefundVo.class);
            if (null == orderRefundVo1){
                orderRefundDaoImpl.create(orderRefundVo);
            }
        }
        /*OrderStatusVo表*/
        OrderStatusVo orderStatusVo = new OrderStatusVo();
        orderStatusVo.setId(tyyOrdersVo.getOrdersn());
        orderStatusVo.setPay_type(tyyOrdersVo.getPaytype());
        orderStatusVo.setPayment_time(tyyOrdersVo.getPaymenttime());
        orderStatusVo.setPayment_status(tyyOrdersVo.getPaystatus());
        if ("1".equals(tyyOrdersVo.getStatus())){
            orderStatusVo.setOrder_status("2");
        }else if("3".equals(tyyOrdersVo.getStatus()) && "0".equals(tyyOrdersVo.getPaystatus())){
            orderStatusVo.setOrder_status("0");
        }else if("3".equals(tyyOrdersVo.getStatus()) && "1".equals(tyyOrdersVo.getPaystatus())){
            orderStatusVo.setOrder_status("1");
        }
        orderStatusVo.setThird_order_id(tyyOrdersVo.getPiaostorderid());
        orderStatusVo.setProduct_company_id(tyyOrdersVo.getEnterpriseid());
        orderStatusVo.setPayment_id(tyyOrdersVo.getTongl_third_ordersn());
        orderStatusVo.setIs_summarize(tyyOrdersVo.getEmancipated());
        orderStatusVo.setSummarize_time(tyyOrdersVo.getEmancipated_date());
        orderStatusVo.setDivide_status(tyyOrdersVo.getProfit_checked());
        orderStatusVo.setDivide_time(tyyOrdersVo.getProfit_checked_date());
        orderStatusVo.setAgent_company_id(tyyOrdersVo.getFxsid());
        orderStatusVo.setIs_delete(tyyOrdersVo.getIsdelete());
        orderStatusVo.setPay_tonglian_id(tyyOrdersVo.getTongl_ordersn());
        /*若该id存在则跳过,不存在则新增*/
        OrderStatusGetReqVo orderStatusGetReqVo = new OrderStatusGetReqVo();
        orderStatusGetReqVo.setId(orderStatusVo.getId());
        OrderStatusVo orderStatusVo1 = orderStatusDaoImpl.load(orderStatusGetReqVo,OrderStatusVo.class);
        if (null == orderStatusVo1){
            orderStatusDaoImpl.create(orderStatusVo);
        }
        /*OrderTicketDetailVo表*/
        OrderTicketDetailVo orderTicketDetailVo = new OrderTicketDetailVo();
        orderTicketDetailVo.setId(StringHelper.getNewID());
        orderTicketDetailVo.setVerify_code(tyyOrderdetailsVo.getAuxiliarycode());
        orderTicketDetailVo.setOrder_id(tyyOrdersVo.getOrdersn());
        orderTicketDetailVo.setTicket_status(tyyOrderdetailsVo.getCodestatus());
        if ("1".equals(tyyOrderdetailsVo.getCodestatus())){
            orderTicketDetailVo.setTime(tyyOrderdetailsVo.getChecktime());
        }else if("2".equals(tyyOrderdetailsVo.getCodestatus())){
            orderTicketDetailVo.setTime(tyyOrderdetailsVo.getRefundtime());
        }
        orderTicketDetailVo.setTicket_code(tyyOrderdetailsVo.getLinkid());
        orderTicketDetailVo.setCode_url(tyyOrderdetailsVo.getPicUrl());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderTicketDetailGetReqVo orderTicketDetailGetReqVo = new OrderTicketDetailGetReqVo();
        orderTicketDetailGetReqVo.setOrder_id(orderTicketDetailVo.getOrder_id());
        OrderTicketDetailVo orderTicketDetailVo1 = orderTicketDetailDao.load(orderTicketDetailGetReqVo,OrderTicketDetailVo.class);
        if (null == orderTicketDetailVo1){
            orderTicketDetailDao.create(orderTicketDetailVo);
        }
        /*OrderTouristVo表*/
        OrderTouristVo orderTouristVo = new OrderTouristVo();
        orderTouristVo.setId(StringHelper.getNewID());
        orderTouristVo.setOrder_id(tyyTouristVo.getOrdersn());
        orderTouristVo.setName(tyyTouristVo.getName());
        orderTouristVo.setPhone(tyyTouristVo.getPhone());
        orderTouristVo.setCredential_type(tyyTouristVo.getCard_type());
        orderTouristVo.setCredential_number(tyyTouristVo.getIdcard());
        /*若该order_id存在则跳过,不存在则新增*/
        OrderTouristGetReqVo orderTouristGetReqVo = new OrderTouristGetReqVo();
        orderTouristGetReqVo.setOrder_id(orderTouristVo.getOrder_id());
        OrderTouristVo orderTouristVo1 = orderTouristDao.load(orderTouristGetReqVo,OrderTouristVo.class);
        if (null == orderTouristVo1){
            orderTouristDao.create(orderTouristVo);
        }
        /*DiscountDetailVo表*/
        DiscountDetailVo discountDetailVo = new DiscountDetailVo();
        discountDetailVo.setId(StringHelper.getNewID());
        discountDetailVo.setOrder_id(tyyOrdersVo.getOrdersn());
        discountDetailVo.setDiscount_money(tyyOrdersVo.getDiscountprice());
        /*若该order_id存在则跳过,不存在则新增*/
        DiscountDetailGetReqVo discountDetailGetReqVo = new DiscountDetailGetReqVo();
        discountDetailGetReqVo.setOrder_id(discountDetailVo.getOrder_id());
        DiscountDetailVo discountDetailVo1 = discountDetailDao.load(discountDetailGetReqVo,DiscountDetailVo.class);
        if (null == discountDetailVo1){
            discountDetailDao.create(discountDetailVo);
        }
    }

}
