package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.ListCompanyReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:25
 */
@Component
public class CompanyDaoImpl extends BaseDaoImpl implements CompanyDao {

    private static final String CHECK_PHONE = "CHECK_PHONE";
    private static final String SELECT = "SELECT";

    @Override
    protected void init() {

        register(CompanyVo.class);

        table.addExist(CHECK_PHONE,"contact_phone");

        table.add(SELECT,"select * from pd_company where 1=1 ")
                .add("companyName","and company_name = ? ")
                .add("companyType","and company_type = ? ")
                .add("companyAttribute","and company_attribute = ? ")
                .add("examineStatus","and examine_status = ?")
                .add("companyId","and invitation_company_id = ? ");
    }

    @Override
    public void checkPhone(CompanyVo companyVo) {
        this.checkExist(CHECK_PHONE,companyVo,"电话号码已存在");
    }

    @Override
    public PageSizeData<CompanyVo> getCompanyList(ListCompanyReqVo reqVo) {
        return this.queryPage(CompanyVo.class,reqVo,SELECT,reqVo);
    }
}
