package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.AuthorityDao;
import com.pangding.web.authority.vo.reqvo.AuthorityGetReqVo;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;
/**
 * @author zhangjinyao
 */
@Component
public class AuthorityDaoImpl extends BaseDaoImpl implements AuthorityDao {

    private static final String CHECK_VALID = "CHECK_VALID";
    private static final String SELECT = "SELECT";

    @Override
    protected void init() {
        register(AuthorityVo.class);

        table.addExist(CHECK_VALID,"name","url");

        table.add(SELECT,"select * from pd_authority where 1=1")
                .add("id","and pid = ? ")
                .add("pid","and pid = ? ")
                .add("levelOne","and pid = ''");
    }

    @Override
    public void checkValid(AuthorityVo authorityVo) {
        this.checkExist(CHECK_VALID,authorityVo,"该权限不合法，请修改权限名或权限url");
    }

    @Override
    public AuthorityVo getAuthority(AuthorityGetReqVo authorityGetReqVo) {
        return this.load(authorityGetReqVo, AuthorityVo.class);
    }

    @Override
    public PageSizeData<AuthorityVo> getAuthorityList(ListAuthorityReqVo reqVo) {
        return this.queryPage(AuthorityVo.class,reqVo,SELECT,reqVo);
    }

    @Override
    public List<AuthorityVo> getAuthoritys(AuthorityGetReqVo reqVo) {
        return this.query(AuthorityVo.class,SELECT,reqVo);
    }

}
