package com.pangding.web.authority.service;


import com.pangding.web.authority.vo.reqvo.LoginReqVo;
import com.pangding.web.authority.vo.reqvo.RegisterEnterpriceReqVo;
import com.pangding.web.authority.vo.reqvo.RegisterIndividualReqVo;
import com.pangding.web.authority.vo.reqvo.RegisterUserReqVo;
import com.pangding.web.authority.vo.CompanyVo;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:21
 */
public interface RegisterService {

    /**
     * 判断注册编码是否正确
     *
     * @param merchantId 注册编码
     * @return false:注册编码错误 true:注册编码正确
     */
    Boolean checkMerchantId(String merchantId);

    /**
     * 保存用户信息，并返回公司信息
     *
     * @param registerUserReqVo
     * @return CompanyVo对象
     */
    CompanyVo saveUser(RegisterUserReqVo registerUserReqVo);

    /**
     * 检查电话号码是否已存在
     *
     * @param contactPhone 联系电话
     */
    void checkPhone(String contactPhone);

    /**
     * 保存个人注册的公司信息
     *
     * @param reqVo
     */
    void saveIndividual(RegisterIndividualReqVo reqVo);

    /**
     * 保存企业注册的公司信息
     *
     * @param reqVo
     */
    void saveEnterprise(RegisterEnterpriceReqVo reqVo);

    /**
     * 登录
     *
     * @param reqVo
     */
    void login(LoginReqVo reqVo);
}
