package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.service.UserService;
import com.pangding.web.tright.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;

    @Override
    public UserVo saveUser(UserDto userDto) {
        UserVo userVo = userDto;
        //

        userDao.create(userVo);
        //userDao.saveUser(userVo);
        saveUserRoles(userVo.getTuId(), userDto.getRoleIds());
        return userVo;
    }

    private void saveUserRoles(Long userId, List<Long> roleIds) {
        if (roleIds != null) {
            //userDao.deleteUserRole(userId);
            if (!CollectionUtils.isEmpty(roleIds)) {
                //userDao.saveUserRoles(userId, roleIds);
            }
        }
    }

    @Override
    public UserVo updateUser(UserDto userDto) {
        userDao.update(userDto);
        saveUserRoles(userDto.getTuId(), userDto.getRoleIds());
        return userDto;
    }

    @Override
    public UserVo getUser(String username) {
        return userDao.getUser(username);
    }

    @Override
    public String passwordEncoder(String credentials, String salt) {
        return null;
    }
}
