package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.WechatUserDao;
import com.pangding.web.authority.vo.WechatUserVo;
import com.pangding.web.authority.vo.reqvo.PrecipitationReqVo;
import com.pangding.web.authority.vo.reqvo.WechatUserGetReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.MapRow;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/29 17:13
 */
@Component
public class WechatUserDaoImpl extends BaseDaoImpl implements WechatUserDao {

    private static final String GET_USER_NUM = "GET_USER_NUM";

    private static final String GET_USER_LIST = "GET_USER_LIST";
    @Override
    protected void init() {

        register(WechatUserVo.class);

        table.add(GET_USER_NUM,"select count(id) as num from pd_wechat_user where 1=1 ")
                .add("sourceCompanyId","and source_company_id = ? ")
                .add("start","and subscribe_date >= ? ")
                .add("end","and subscribe_date < ? ");

        table.add(GET_USER_LIST,"select * from pd_wechat_user where 1=1 {WHERE} order by subscribe_date desc")
                .add("start","and subscribe_date >= ? ")
                .add("end","and subscribe_date < ? ")
                .add("sourceCompanyId","and source_company_id = ? ");
    }

    @Override
    public Object getUserNum(WechatUserGetReqVo getReqVo) {
        return this.query(GET_USER_NUM,getReqVo);
    }

    @Override
    public PageSizeData<WechatUserVo> getUserList(WechatUserGetReqVo reqVo) {
        return this.queryPage(WechatUserVo.class,reqVo,GET_USER_LIST,reqVo);
    }
}
