package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.*;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/19 16:49
 */
public interface PangdingPartnerService {
    /**
     * 胖丁伙伴首页
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    HomeResVo home(HomeReqVo reqVo);

    /**
     * 通过公司id获取该公司的可提现余额以及默认提现银行卡
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    MobileWithdrawalResVo withdrawal(MobileWithdrawalReqVo reqVo);

    /**
     * 通过公司id获取该公司银行卡列表（不分页）
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    List<CompanyBankCardVo> bankCardList(MobileBankCardListReqVo reqVo);

    /**
     * 保存/更新银行卡信息，并调用第三方接口发送手机验证码
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    String saveBank(CompanyBankCardVo reqVo);

    /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    CompanyBankCardVo bankSubmit(BankSubmitReqVo reqVo);

    /**
     * 调用支付服务解绑银行卡，并更新银行卡状态
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    void deleteBank(CompanyBankCardVo reqVo);

    /**
     * 设置该银行卡为默认支付，并取消其他银行卡的默认
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    void setDefault(CompanyBankCardVo reqVo);

    /**
     * 我的管理页面：通过userId获取用户表，公司表，公司银行卡表数据
     * @param reqVo 封装了userId的请求对象
     * @return
     */
    ManagementResVo management(ManagementReqVo reqVo);

    /**
     * 根据公司id获取该公司今日用户沉淀量，总沉淀量，沉淀用户列表
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    PrecipitationResVo precipitation(PrecipitationReqVo reqVo);

    /**
     * 根据公司id返回该公司二维码url，若没有则创建
     * @param reqVo 封装了公司id和选项（限制为永久）的请求对象
     * @return
     */
    String qrCodeUrl(GenerateQrCodeUrlReqVo reqVo);

    /**
     * 根据公司id获取该公司的邀请码，若没有则创建
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    String invitation(InvitationReqVo reqVo);

    /**
     * 邀请商家列表
     * @param reqVo
     * @return
     */
    InviteMembersResVo inviteMembers(InviteMembersReqVo reqVo);
}
