package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.req.company.UpdateCompanyMoneyReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 17:22
 */
@Component
public class CompanyExtendDaoImpl extends BaseDaoImpl implements CompanyExtendDao {


    private static final String UPDATE_COMPANY_MONEY = "UPDATE_COMPANY_MONEY";


    @Override
    protected void init() {
        register(CompanyExtendVo.class);

        table.add(UPDATE_COMPANY_MONEY, "UPDATE pd_company_extend SET withdraw_total_cash = @newWithdrawTotalCash " +
                "WHERE id = @companyId AND withdraw_total_cash = @oldWithdrawTotalCash");


    }

    @Override
    public void updateCompanyMoney(UpdateCompanyMoneyReqVo req) {
        this.updateSql(UPDATE_COMPANY_MONEY, req);
    }


}
