package com.pangding.web.authority.vo;


import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.BaseVo;
import com.yanzuoguang.util.vo.InitDao;

/**
 * 日志服务表结构映射
 *
 * @author 颜佐光
 */
@TableAnnotation("login_token")
public class LoginVo extends BaseVo implements InitDao {
    /**
     * 编号,主键请放第一个
     * 假如是一样的字段，则不需要写映射.下面的代码添加映射关系
     */
    private String token;
    /**
     * 数据密钥
     */
    @TableAnnotation("data_pwd")
    private String dataPwd;

    /**
     * 登录数据
     */
    private String data;
    /**
     * 失效时间
     */
    @TableAnnotation("expair_time")
    private String expairTime;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getDataPwd() {
        return dataPwd;
    }

    public void setDataPwd(String dataPwd) {
        this.dataPwd = dataPwd;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getExpairTime() {
        return expairTime;
    }

    public void setExpairTime(String expairTime) {
        this.expairTime = expairTime;
    }

    @Override
    public void init() {
        this.token = StringHelper.getFirst(this.token);
        this.dataPwd = StringHelper.getFirst(this.dataPwd);
        this.data = StringHelper.getFirst(this.data);
        this.expairTime = StringHelper.getFirstNull(this.expairTime);
    }
}
