package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyDao;
import com.pangding.web.authority.vo.reqvo.ListCompanyReqVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:25
 */
@Component
public class CompanyDaoImpl extends BaseDaoImpl implements CompanyDao {

    private static final String SELECT = "SELECT";



    @Override
    protected void init() {

        register(CompanyVo.class);

        table.add(SELECT,"select a.*,b.invitation_code,b.withdraw_total_cash  from pd_company a inner join pd_company_extend b on a.id = b.id " +
                "where 1=1 {WHERE} order by create_time desc")
                .add("companyName","and company_name = ? ")
                .add("companyType","and company_type = ? ")
                .add("companyAttribute","and company_attribute = ? ")
                .add("examineStatus","and examine_status = ?")
                .add("companyId","and invitation_company_id = ? ");

        getSql(DaoConst.LOAD).addCode("{FIELD}", ",b.*", "{INNER}", "INNER JOIN pd_company_extend b ON a.id = b.id");



    }

    @Override
    public PageSizeData<CompanyResVo> getCompanyList(ListCompanyReqVo reqVo) {
        return this.queryPage(CompanyResVo.class,reqVo,SELECT,reqVo);
    }
}
