package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.reqvo.BankCardListReqVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 19:17
 */
@Component
public class CompanyBankCardDaoImpl extends BaseDaoImpl implements CompanyBankCardDao {
    private static final String GET_BANK_CARD_LIST = "GET_BANK_CARD_LIST";

    @Override
    protected void init() {
        register(CompanyBankCardVo.class);

        table.add(GET_BANK_CARD_LIST,"select * from pd_company_bank_card where 1=1 ")
                .add("companyId","and company_id = ?");
    }

    /**
     * 获取银行卡列表分页数据
     * @param reqVo
     * @return
     */
    @Override
    public PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo) {
        return this.queryPage(CompanyBankCardVo.class,reqVo,GET_BANK_CARD_LIST,reqVo);
    }
}
