package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.service.IndexService;
import com.pangding.web.authority.vo.CompanyExtendVo;
import com.pangding.web.authority.vo.reqvo.TotalIncomeReqVo;
import com.pangding.web.authority.vo.reqvo.WithdrawCashReqVo;
import com.yanzuoguang.util.exception.CodeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @Author zhangjinyao
 * @create 2019/5/27 11:19
 */
@Service
public class IndexServiceImpl implements IndexService {
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;

    /**
     * 通过公司id获取该公司的可提现余额
     * @param reqVo 封装了公司id的请求对象
     * @return 可提现的金额
     */
    @Override
    public BigDecimal getWithdrawCash(WithdrawCashReqVo reqVo) {
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo,CompanyExtendVo.class);
        if (null == companyExtendVo){
            throw new CodeException("未查到该公司数据");
        }
        BigDecimal cash = companyExtendVo.getWithdrawTotalCash();
        if (null == cash){
            throw new CodeException("暂无可提现余额信息");
        }
        return cash;
    }

    @Override
    public BigDecimal getTotalIncome(TotalIncomeReqVo reqVo) {
        /*此处需调用订单服务获取累积总收益
        * 目前仅返回null*/
        return null;
    }
}
