package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.service.VerifyCodeService;
import com.pangding.web.authority.util.VerifyCodeConstant;
import com.pangding.web.authority.util.VerifyCodeUtil;
import com.yanzuoguang.util.exception.CodeException;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * @Author zhangjinyao
 * @create 2019/5/23 11:51
 */
@Service
public class VerifyCodeServiceImpl implements VerifyCodeService {
    /**
     * 获取验证码
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @Override
    public void getImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", VerifyCodeConstant.EXPIRES);
        response.setContentType("image/jpeg");
        // 生成随机字串
        String verifyCode = VerifyCodeUtil.generateVerifyCode(VerifyCodeConstant.VERIFY_SIZE);
        // 存入会话session
        HttpSession session = request.getSession(true);
        // 删除以前的
        session.removeAttribute("verCode");
        session.removeAttribute("codeTime");
        session.setAttribute("verCode", verifyCode.toLowerCase());
        session.setAttribute("codeTime", LocalDateTime.now());
        // 生成图片
        int width = VerifyCodeConstant.WIDTH;
        int height = VerifyCodeConstant.HEIGHT;
        OutputStream out = response.getOutputStream();
        VerifyCodeUtil.outputImage(width, height, out, verifyCode);
    }

    /**
     * 验证验证码
     *
     * @param verifyCode
     * @param session
     * @return
     */
    @Override
    public void validImage(String verifyCode, HttpSession session) {
        String code = verifyCode;
        Object verCode = session.getAttribute("verCode");
        if (null == verCode) {
            throw new CodeException("验证码已失效，请重新输入");
        }
        String verCodeStr = verCode.toString();
        LocalDateTime localDateTime = (LocalDateTime)session.getAttribute("codeTime");
        long past = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long now = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        if(verCodeStr == null || code == null || code.isEmpty() || !verCodeStr.equalsIgnoreCase(code)){
            throw new CodeException("验证码错误");
        } else if((now-past)/VerifyCodeConstant.MILLISECOND/VerifyCodeConstant.SECOND>VerifyCodeConstant.LIMIT_SECOND){
            throw new CodeException("验证码已过期，重新获取");
        } else {
            //验证成功，删除存储的验证码
            session.removeAttribute("verCode");
            return;
        }
    }
}
