package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.AgreementService;
import com.pangding.web.vo.system.req.AgreementTemplateReqVo;
import com.pangding.web.vo.system.res.AgreementTemplateResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author tangfang
 * @date 2020-08-31 19:03:23
 * 合同模板
 */
@RestController
@RequestMapping(value = "/agreement", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "合同模板类", description = "合同模板的查询，新增，修改，删除等相关操作")
public class AgreementController {

    @Autowired
    private AgreementService agreementService;

    @RequestMapping(value = "/getListAgreement")
    @ApiOperation(value = "获取合同模板列表", notes = "返回合同模板列表")
    public ResponseResult getListAgreement(@RequestBody AgreementTemplateReqVo req) {

        return ResponseResult.result(agreementService.findAgreemnetList(req));
    }

    @RequestMapping(value = "/findAgreement")
    @ApiOperation(value = "获取合同详情", notes = "返回合同详情")
    public ResponseResult<AgreementTemplateResVo> findAgreement(@RequestBody AgreementTemplateReqVo req) {
        return ResponseResult.result(agreementService.findAgreementDetail(req));
    }

    @RequestMapping(value = "/saveAgreementTemplate")
    @ApiOperation(value = "保存合同模板", notes = "返回保存合同结果")
    public ResponseResult saveAgreementTemplate(@RequestBody AgreementTemplateReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("agreementName", req.getAgreementName())
                .notBlankCheck("agreementType", req.getAgreementType())
                .notBlankCheck("companyAttribute", req.getCompanyAttribute())
                .notBlankCheck("agreementContent", req.getAgreementContent())
                .notBlankCheck("agreementFileUrl", req.getAgreementFileUrl())
                .checkException();
        return ResponseResult.result(agreementService.saveAgreement(req));
    }

    @RequestMapping(value = "/removeAgreement")
    @ApiOperation(value = "删除合同模板", notes = "返回删除结果")
    public ResponseResult removeAgreement(@RequestBody AgreementTemplateReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("agreementId", req.getAgreementId())
                .checkException();
        agreementService.removeAgreement(req);
        return ResponseResult.result("");
    }

}
