package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.TokenDao;
import com.pangding.web.vo.system.pd.LoginTokenVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

/**
 * 登录数据库写入实现类
 *
 * @author 颜佐光
 */
@Component
public class TokenDaoImpl extends BaseDaoImpl implements TokenDao {

    private static final int TOKEN_MEMORY_CACHE_TIME = 60;

    /**
     * 注册SQL语句
     */
    @Override
    protected void init() {
        // 根据实体生成增删改查语句
        register(LoginTokenVo.class);

        cacheList.setClearSecond(TOKEN_MEMORY_CACHE_TIME);
    }
}
