package com.pangding.web.authority.service.company.impl;

import com.pangding.web.authority.dao.company.CompanyTollPointDao;
import com.pangding.web.authority.service.company.CompanyTollPointService;
import com.pangding.web.vo.system.pd.company.CompanyTollPointVo;
import com.pangding.web.vo.system.req.company.CompanyTollPointReqVo;
import com.pangding.web.vo.system.res.company.CompanyTollPointResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyTollPointServiceImpl implements CompanyTollPointService {

    private CompanyTollPointDao companyTollPointDao;

    public CompanyTollPointServiceImpl(CompanyTollPointDao companyTollPointDao) {
        this.companyTollPointDao = companyTollPointDao;
    }

    public PageSizeData<CompanyTollPointResVo> queryPageList(CompanyTollPointReqVo req) {

        PageSizeData<CompanyTollPointResVo> companyTollPointVo = companyTollPointDao.queryPageList(req);

        return companyTollPointVo;
    }

    public CompanyTollPointVo save(CompanyTollPointReqVo req) {

        CompanyTollPointReqVo companyTollPointReqVo = new CompanyTollPointReqVo();
        companyTollPointReqVo.setCompanyId(req.getCompanyId());
        companyTollPointReqVo.setTollPoints(req.getTollPoints());
        CompanyTollPointVo companyTollPointVo = companyTollPointDao.load(companyTollPointReqVo, CompanyTollPointVo.class);
        if (StringHelper.isEmpty(companyTollPointVo)) {
            companyTollPointVo = new CompanyTollPointVo();
            ObjectHelper.writeWithFromClass(companyTollPointVo, req);
            companyTollPointVo.setCompanyPointId(StringHelper.getNewID());
            companyTollPointDao.create(companyTollPointVo);
        } else {
            req.setCompanyPointId(companyTollPointVo.getCompanyPointId());
            companyTollPointDao.update(req);
        }
        return companyTollPointVo;
    }

    public CompanyTollPointVo queryCompanyTollPoint(CompanyTollPointReqVo req) {

        CompanyTollPointVo companyTollPointVo = companyTollPointDao.load(req, CompanyTollPointVo.class);

        return companyTollPointVo;
    }

    public List<CompanyTollPointVo> queryList(CompanyTollPointReqVo req) {

        List<CompanyTollPointVo> companyTollPointVo = companyTollPointDao.loadList(req, CompanyTollPointVo.class);

        return companyTollPointVo;
    }

    public void delCompanyTollPoint(CompanyTollPointReqVo req) {

        companyTollPointDao.remove(req);
    }

}
