package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.AgreementTemplateDao;
import com.pangding.web.authority.dao.CompanyAgreementDao;
import com.pangding.web.authority.dao.company.CompanyDao;
import com.pangding.web.authority.dao.company.CompanyExtendDao;
import com.pangding.web.authority.service.CompanyAgreementService;
import com.pangding.web.vo.system.pd.AgreementTemplateVo;
import com.pangding.web.vo.system.pd.company.CompanyAgreementVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.company.CompanyAgreementReqVo;
import com.pangding.web.vo.system.res.company.CompanyAgreementResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class CompanyAgreementServiceImpl implements CompanyAgreementService {

    private final CompanyAgreementDao companyAgreementDao;

    private final AgreementTemplateDao agreementTemplateDao;

    private final CompanyDao companyDao;

    private final CompanyExtendDao companyExtendDao;


    public CompanyAgreementServiceImpl(CompanyAgreementDao companyAgreementDao,
                                       AgreementTemplateDao agreementTemplateDao,
                                       CompanyDao companyDao, CompanyExtendDao companyExtendDao) {
        this.companyAgreementDao = companyAgreementDao;
        this.agreementTemplateDao = agreementTemplateDao;
        this.companyDao = companyDao;
        this.companyExtendDao = companyExtendDao;
    }

    @Override
    public CompanyAgreementResVo findCompanyAgreement(CompanyAgreementReqVo req) {
        CompanyAgreementResVo companyAgreementResVo = companyAgreementDao.load(req, CompanyAgreementResVo.class);
        return companyAgreementResVo;
    }

    @Override
    public PageSizeData<CompanyAgreementVo> findCompanyAgreementList(CompanyAgreementReqVo req) {
        PageSizeData<CompanyAgreementVo> companyAgreementResVo = companyAgreementDao.findCompanyAgreement(req);
        return companyAgreementResVo;
    }

    @Override
    public CompanyAgreementVo saveCompanyAgreement(CompanyAgreementReqVo req) {

        CompanyResVo companyResVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        if(StringHelper.isEmpty(companyResVo)){
            throw new CodeException("未找到公司信息");
        }

        AgreementTemplateVo agreementTemplateVo = agreementTemplateDao.load(req.getAgreementId(), AgreementTemplateVo.class);
        if(StringHelper.isEmpty(agreementTemplateVo)){
            throw new CodeException("未找到可签约的合同");
        }
        String id = StringHelper.getMD5Id(req.getCompanyId(), req.getAgreementId());
        CompanyAgreementVo companyAgreementVo = companyAgreementDao.load(id, CompanyAgreementVo.class);
        if (!StringHelper.isEmpty(companyAgreementVo)) {
            throw new CodeException("已签署合同");
        }
        companyAgreementVo = new CompanyAgreementVo();
        ObjectHelper.writeWithFrom(companyAgreementVo, req);
        companyAgreementVo.setCompanyAgreementId(id);
        companyAgreementVo.setAgreementContent(agreementTemplateVo.getAgreementContent());
        companyAgreementVo.setAgreementName(agreementTemplateVo.getAgreementName());
        companyAgreementVo.setAgreementFilePath(agreementTemplateVo.getAgreementFileUrl());
        companyAgreementVo.setCreateTime(DateHelper.getNow());
        companyAgreementVo.setAgreementType(agreementTemplateVo.getAgreementType());
        companyAgreementDao.create(companyAgreementVo);

        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        ObjectHelper.writeWithFromClass(companyExtendVo, companyResVo);
        // 设置提现信息
        companyExtendVo.setWithdrawRule(1);
        companyExtendVo.setWithdrawType("D0");
        companyExtendVo.setWithdrawDateType(0);
        companyExtendVo.setMinWithdrawMoney(1d);
        companyExtendVo.setMaxWithdrawMoney(2000000d);
        companyExtendVo.setWithdrawFee(1d);
        companyExtendVo.setDiscountRule(0);
         // 设置系统服务费
        companyExtendVo.setServiceChargeStatus(req.getServiceChargeStatus());
        companyExtendVo.setServiceChargeMoneyType(req.getServiceChargeMoneyType());
        companyExtendVo.setServiceChargePayType(req.getServiceChargePayType());
        companyExtendVo.setServiceChargeType(req.getServiceChargeType());
        companyExtendVo.setServiceCharge(req.getServiceCharge());
        // 设置分润信息
        companyExtendVo.setDivideStatus(0);
        companyExtendVo.setScanCodePayStatus(1);
        companyExtendVo.setInvitationStatus(0);
        companyExtendVo.setActivationStatus(0);
        companyExtendDao.update(companyExtendVo);

        CompanyVo companyVo = new CompanyVo();
        ObjectHelper.writeWithFromClass(companyVo, companyResVo);
        companyVo.setSigningStatus(1);
        companyVo.setSigningTime(DateHelper.getNow());
        companyVo.setSigningType(req.getSigningType());
        companyVo.setExamineStatus(1);
        companyDao.update(companyVo);
        return companyAgreementVo;
    }

}
