package com.pangding.web.system.service.impl;

import com.pangding.web.system.dao.SystemWarnDao;
import com.pangding.web.system.service.SystemWarnService;
import com.pangding.web.vo.system.pd.SystemWarnVo;
import com.pangding.web.vo.system.req.SystemWarnPageReqVo;
import com.pangding.web.vo.system.req.SystemWarnReqVo;
import com.pangding.web.vo.system.res.SystemWarnListResVo;
import com.pangding.web.vo.system.res.SystemWarnResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.core.codec.CodecException;
import org.springframework.stereotype.Service;

@Service
public class SystemWarnServiceImpl implements SystemWarnService {

    private SystemWarnDao systemWarnDao;

    public SystemWarnServiceImpl(SystemWarnDao systemWarnDao) {
        this.systemWarnDao = systemWarnDao;
    }

    public SystemWarnListResVo findListPage(SystemWarnPageReqVo req){
        PageSizeData<SystemWarnResVo> systemWarnResVoPageSizeData = systemWarnDao.findListPage(req);
        SystemWarnResVo systemWarnResVo = systemWarnDao.findListTotal(req);
        SystemWarnListResVo systemWarnListResVo = new SystemWarnListResVo();
        systemWarnListResVo.setSystemWarnResVoPageSizeData(systemWarnResVoPageSizeData);
        systemWarnListResVo.setSystemWarnResVo(systemWarnResVo);
        return systemWarnListResVo;
    }

    public SystemWarnResVo find(SystemWarnReqVo req){
        return systemWarnDao.load(req, SystemWarnResVo.class);
    }

    public void save(SystemWarnReqVo req){
        SystemWarnReqVo sqlReq = new SystemWarnReqVo();
        sqlReq.setCompanyName(req.getCompanyName());
        sqlReq.setMerchantName(req.getMerchantName());
        sqlReq.setProductName(req.getProductName());
        sqlReq.setWarnName(req.getWarnName());
        sqlReq.setWarnType(req.getWarnType());
        sqlReq.setChannelType(req.getChannelType());
        SystemWarnResVo systemWarnResVo = systemWarnDao.load(sqlReq, SystemWarnResVo.class);
        if(StringHelper.isEmpty(systemWarnResVo)){
            SystemWarnVo systemWarnVo = new SystemWarnVo();
            ObjectHelper.writeWithFromClass(systemWarnVo, req);
            systemWarnDao.create(systemWarnVo);
        }else{
            ObjectHelper.writeWithFromClass(systemWarnResVo, req);
            systemWarnDao.update(systemWarnResVo);
        }
    }

    public void updateWarn(SystemWarnReqVo req){

        SystemWarnResVo systemWarnResVo = systemWarnDao.load(req.getSystemWarningId(), SystemWarnResVo.class);
        if(StringHelper.isEmpty(systemWarnResVo)){
//            throw new CodecException("00", "未找到数据");
        }
//        systemWarnResVo.setRemark(req.getRemark());
        systemWarnResVo.setWarnStatus(req.getWarnStatus());
        systemWarnDao.update(systemWarnResVo);

    }

}
