package com.tcm.system.role.dao.impl;

import com.tcm.system.role.dao.TcmRoleDao;
import com.tcm.system.role.vo.TcmRoleVo;
import com.tcm.system.role.vo.req.TcmRolePageReqVo;
import com.tcm.system.role.vo.res.TcmRoleListResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class TcmRoleDaoImpl extends BaseDaoImpl implements TcmRoleDao {

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {
        register(TcmRoleVo.class);

        table.add(QUERY_LIST, "select COUNT(a.role_id) as userNum,a.* from tcm_sys_role a " +
                " LEFT JOIN tcm_sys_user b on a.role_id = b.role_id where 1=1 {WHERE}" +
                "GROUP BY a.role_id")
                .add("roleId", " and a.role_id = ? ")
                .add("companyId", " and a.company_id = ? ")
                .add("roleName", " and (a.name LIKE concat(?,'%') OR a.remark LIKE concat(?,'%') )");
    }

    @Override
    public PageSizeData<TcmRoleListResVo> queryList(TcmRolePageReqVo req) {
        return this.queryPage(TcmRoleListResVo.class, req, QUERY_LIST, req);
    }

}
