package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.util.RoleConstant;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.AuthorityService;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.resvo.AuthorityListByLevelResVo;
import com.pangding.web.authority.vo.resvo.AuthorityListResVo;
import com.pangding.web.authority.vo.resvo.AuthorityResVo;
import com.pangding.web.authority.vo.resvo.WebAuthorityResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author zhangjinyao
 */
@Service
public class AuthorityServiceImpl implements AuthorityService {

    @Autowired
    AuthorityDao authorityDao;
    @Autowired
    RoleAuthorityDao roleAuthorityDao;
    @Autowired
    UserDao userDaoImpl;
    @Autowired
    UserRoleDao userRoleDaoImpl;
    @Autowired
    private RegisterServiceImpl registerServiceImpl;
    @Autowired
    private RoleDao roleDaoImpl;

    /**
     * 保存authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     * @return 用户id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuthorityListResVo save(AuthorityVo authorityVo) {
        /*this.checkValid(authorityVo);*/
        if (null == authorityVo.getPid() || authorityVo.getPid().isEmpty()){
            authorityVo.setPid("");
        }
        afterPlus(authorityVo);
        authorityVo.setId(StringHelper.getNewID());
        authorityDao.create(authorityVo);

        AuthorityListReqVo reqVo = new AuthorityListReqVo();
        reqVo.setLevelOne("levelOne");
        return this.getListByLevel(reqVo);
    }

    /**
     * 将权限新排序后面所有的权限排序+1
     * @param authorityVo 权限对象
     */
    private void afterPlus(AuthorityVo authorityVo){
        AuthorityGetReqVo reqVo = new AuthorityGetReqVo();
        reqVo.setPid(authorityVo.getPid());
        reqVo.setSort(authorityVo.getSort());
        AuthorityVo authorityVo1 = authorityDao.load(reqVo,AuthorityVo.class);
        if (authorityVo1 != null){
            AuthorityAfterReqVo afterReqVo = new AuthorityAfterReqVo();
            ObjectHelper.writeWithFrom(afterReqVo,authorityVo);
            List<AuthorityVo> authorityVoList = authorityDao.after(afterReqVo);
            for (AuthorityVo authorityVo2:authorityVoList) {
                Integer sort = authorityVo2.getSort();
                Integer newSort = sort+1;
                authorityVo2.setSort(newSort);
                authorityDao.update(authorityVo2);
            }
        }
    }

    private void afterSub(AuthorityVo authorityVo){
        AuthorityGetReqVo getReqVo = new AuthorityGetReqVo();
        getReqVo.setId(authorityVo.getId());
        AuthorityVo authorityVo1 = authorityDao.load(getReqVo,AuthorityVo.class);
        if (authorityVo1 != null){
            AuthorityAfterReqVo afterReqVo = new AuthorityAfterReqVo();
            ObjectHelper.writeWithFrom(afterReqVo,authorityVo);
            List<AuthorityVo> authorityVoList = authorityDao.after(afterReqVo);
            for (AuthorityVo authorityVo2:authorityVoList) {
                Integer sort = authorityVo2.getSort();
                Integer newSort = sort-1;
                authorityVo2.setSort(newSort);
                authorityDao.update(authorityVo2);
            }
        }
    }

    /**
     * 更新authorityVo对象数据
     *
     * @param authorityVo authorityVo对象
     * @return 用户id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuthorityListResVo update(AuthorityVo authorityVo) {
        /*this.checkValid(authorityVo);*/
        if (null == authorityVo.getPid() || authorityVo.getPid().isEmpty()){
            authorityVo.setPid("");
        }
        afterSub(authorityVo);
        afterPlus(authorityVo);
        authorityDao.update(authorityVo);
        AuthorityListReqVo reqVo = new AuthorityListReqVo();
        reqVo.setLevelOne("levelOne");
        return this.getListByLevel(reqVo);
    }

    /**
     * 检查新建、修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     * @return 0：合法 else：不合法
     */
    @Override
    public void checkValid(AuthorityVo authorityVo) {
        authorityDao.checkValid(authorityVo);
    }

    /**
     * 通过权限表主键获取authorityVo对象
     *
     * @param reqVo 主键
     * @return authorityVo对象
     */
    @Override
    public AuthorityResVo getAuthorityById(WebAuthorityReqVo reqVo) {
        AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
        authorityGetReqVo.setId(reqVo.getId());
        AuthorityVo authorityVo = authorityDao.load(authorityGetReqVo,AuthorityVo.class);
        if (authorityVo == null){
            throw new CodeException("该权限不存在");
        }

        AuthorityResVo resVo = new AuthorityResVo();
        ObjectHelper.writeWithFrom(resVo,authorityVo);

        if (null != authorityVo.getPid() && !authorityVo.getPid().isEmpty()){
            AuthorityGetReqVo getReqVo = new AuthorityGetReqVo();
            getReqVo.setId(authorityVo.getPid());
            AuthorityVo parent = authorityDao.load(getReqVo,AuthorityVo.class);
            if (null != parent){
                resVo.setParentName(parent.getName());
            }
        }
        return resVo;
    }

    /**
     * 通过权限表主键删除authorityVo对象，并删除权限和角色的对应关系
     * 递归删除其子权限
     *
     * @param reqVo 主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteAuthorityById(WebAuthorityReqVo reqVo) {

        /*将该权限排序后的权限排序-1*/
        AuthorityGetReqVo getReqVo = new AuthorityGetReqVo();
        getReqVo.setId(reqVo.getId());
        AuthorityVo authority = authorityDao.load(getReqVo,AuthorityVo.class);
        if (null != authority){
            afterSub(authority);
        }

        AuthorityGetReqVo reqVo1 = new AuthorityGetReqVo();
        reqVo1.setPid(reqVo.getId());
        List<AuthorityVo> childList = authorityDao.loadList(reqVo1,AuthorityVo.class);
        if (childList != null && !childList.isEmpty()){
            for (AuthorityVo child:childList) {
                WebAuthorityReqVo reqVo2 = new WebAuthorityReqVo();
                reqVo2.setId(child.getId());
                this.deleteAuthorityById(reqVo2);
            }
        }

        AuthorityVo authorityVo = new AuthorityVo();
        authorityVo.setId(reqVo.getId());
        authorityDao.remove(authorityVo);

        RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
        roleAuthorityGetReqVo.setAuthorityId(reqVo.getId());
        List<RoleAuthorityVo> roleAuthorityList = roleAuthorityDao.loadList(roleAuthorityGetReqVo,RoleAuthorityVo.class);
        for (RoleAuthorityVo roleAuthority:roleAuthorityList) {
            roleAuthorityDao.remove(roleAuthority);
        }
    }

    /**
     * 获取权限返回信息分页对象
     *
     * @param reqVo
     * @return 权限返回信息分页对象
     */
    @Override
    public PageSizeData<WebAuthorityResVo> getWebAuthorityResVoList(ListAuthorityByPageReqVo reqVo) {
        PageSizeData<AuthorityVo> authorityVoPageSizeData = authorityDao.getAuthorityList(reqVo);
        PageSizeData<WebAuthorityResVo> webAuthorityResVoPageSizeData = new PageSizeData();
        List<AuthorityVo> authorityVoList = authorityVoPageSizeData.getList();
        if (authorityVoList == null || authorityVoList.isEmpty()){
            throw new CodeException("没有更多权限");
        }
        List<WebAuthorityResVo> webAuthorityResVoList = new ArrayList(authorityVoList.size());
        for (AuthorityVo authorityVo:authorityVoList) {
            WebAuthorityResVo resVo = new WebAuthorityResVo();
            ObjectHelper.writeWithFrom(resVo,authorityVo);
            if (null != authorityVo.getPid() && !authorityVo.getPid().isEmpty()){
                AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
                authorityGetReqVo.setId(authorityVo.getPid());
                AuthorityVo parent = authorityDao.load(authorityGetReqVo,AuthorityVo.class);
                resVo.setParentName(parent.getName());
            }
            webAuthorityResVoList.add(resVo);
        }
        ObjectHelper.writeWithFrom(webAuthorityResVoPageSizeData,authorityVoPageSizeData);
        webAuthorityResVoPageSizeData.setList(webAuthorityResVoList);

        return webAuthorityResVoPageSizeData;
    }

    /**
     * 查询不分页权限列表
     * @return
     */
    @Override
    public List<AuthorityVo> getAuthorityList(AuthorityListReqVo reqVo) {
        List<AuthorityVo> authorityVoList = authorityDao.loadList(reqVo,AuthorityVo.class);
        if (null == authorityVoList || authorityVoList.isEmpty()){
            throw new CodeException("暂无权限，请先添加");
        }
        return authorityVoList;
    }

    @Override
    public AuthorityListResVo getListByLevel(AuthorityListReqVo reqVo) {
        RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
        roleGetReqVo.setCompanyId(reqVo.getCompanyId());
        roleGetReqVo.setIsAdmin(1);
        RoleVo roleVo = roleDaoImpl.load(roleGetReqVo,RoleVo.class);
        if (roleVo == null){
            throw new CodeException("该公司用户未设置管理员角色");
        }
        Set authorityIdSet = new HashSet();

        RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
        roleAuthorityGetReqVo.setRoleId(roleVo.getId());
        List<RoleAuthorityVo> roleAuthorityVoList = roleAuthorityDao.loadList(roleAuthorityGetReqVo,RoleAuthorityVo.class);
        for (RoleAuthorityVo roleAuthorityVo:roleAuthorityVoList) {
            authorityIdSet.add(roleAuthorityVo.getAuthorityId());
        }

        List<String> authorityIdList = new ArrayList<>();
        Object[] objs = authorityIdSet.toArray();
        for (Object obj:objs) {
            authorityIdList.add((String) obj);
        }
        List<AuthorityVo> levelOneList = new ArrayList();
        for (int i = 0; i < authorityIdList.size(); i++) {
            AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
            authorityGetReqVo.setId(authorityIdList.get(i));
            AuthorityVo authorityVo = authorityDao.load(authorityGetReqVo,AuthorityVo.class);
            if (null == authorityVo.getPid() || authorityVo.getPid().isEmpty()){
                levelOneList.add(authorityVo);
                authorityIdList.set(i,"");
            }
        }
        List<String> authorityIds = new ArrayList<>();
        for (int i = 0; i < authorityIdList.size(); i++) {
            if (!"".equals(authorityIdList.get(i))){
                authorityIds.add(authorityIdList.get(i));
            }
        }
        Collections.sort(levelOneList);
        if (levelOneList.isEmpty()){
            throw new CodeException("该用户暂无权限，请添加");
        }
        List<AuthorityListByLevelResVo> authorityListByLevel = new ArrayList<>();
        for (AuthorityVo authorityVo:levelOneList) {
            AuthorityListByLevelResVo resVo1 = new AuthorityListByLevelResVo();
            ObjectHelper.writeWithFrom(resVo1,authorityVo);
            List<AuthorityListByLevelResVo> childList = registerServiceImpl.getChildList(authorityVo,authorityIds);
            resVo1.setChildList(childList);
            authorityListByLevel.add(resVo1);
        }
        Collections.sort(authorityListByLevel);
        AuthorityListResVo authorityListResVo = new AuthorityListResVo();
        authorityListResVo.setAuthorityListByLevel(authorityListByLevel);

        /*若roleId存在，则需要返回该角色拥有的权限列表*/
        if (null != reqVo.getRoleId() && !reqVo.getRoleId().isEmpty()){
            RoleAuthorityGetReqVo roleAuthorityGetReqVo1 = new RoleAuthorityGetReqVo();
            roleAuthorityGetReqVo1.setRoleId(reqVo.getRoleId());
            List<RoleAuthorityVo> roleAuthorityVos = roleAuthorityDao.loadList(roleAuthorityGetReqVo1,RoleAuthorityVo.class);
            List<AuthorityVo> authorityVoList = new ArrayList<>();
            if (null != roleAuthorityVos && !roleAuthorityVos.isEmpty()){
                for (RoleAuthorityVo roleAuthorityVo:roleAuthorityVos) {
                    AuthorityGetReqVo getReqVo = new AuthorityGetReqVo();
                    getReqVo.setId(roleAuthorityVo.getAuthorityId());
                    AuthorityVo authorityVo = authorityDao.load(getReqVo,AuthorityVo.class);
                    if (null != authorityVo){
                        authorityVoList.add(authorityVo);
                    }
                }
            }
            authorityListResVo.setAuthorityListByRole(authorityVoList);
        }

        return authorityListResVo;
    }

    private List<AuthorityListByLevelResVo> getChildList(String id){
        AuthorityGetReqVo reqVo = new AuthorityGetReqVo();
        reqVo.setPid(id);
        List<AuthorityVo> childList = authorityDao.listBySort(reqVo);
        List<AuthorityListByLevelResVo> childResList = new ArrayList();
        if (null != childList && !childList.isEmpty()){
            for (AuthorityVo authorityVo:childList) {
                AuthorityListByLevelResVo resVo = new AuthorityListByLevelResVo();
                ObjectHelper.writeWithFrom(resVo,authorityVo);
                List<AuthorityListByLevelResVo> grandchildList = getChildList(authorityVo.getId());
                resVo.setChildList(grandchildList);
                childResList.add(resVo);
            }
        }
        return childResList;
    }

    @Override
    public List<AuthorityListByLevelResVo> getCompanyAuthority(CompanyAuthorityReqVo reqVo) {
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setCompanyId(reqVo.getCompanyId());
        userGetReqVo.setIsFirst(1);
        UserVo superAdmin = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null == superAdmin){
            throw new CodeException("暂无超级管理员");
        }
        UserRoleGetReqVo getReqVo = new UserRoleGetReqVo();
        getReqVo.setUserId(superAdmin.getId());
        List<UserRoleVo> userRoleVoList = userRoleDaoImpl.loadList(getReqVo,UserRoleVo.class);
        if (null == userRoleVoList || userRoleVoList.isEmpty()){
            throw new CodeException("暂无权限");
        }
        List<RoleAuthorityVo> roleAuthorityVoList = new ArrayList();
        for (UserRoleVo userRoleVo:userRoleVoList) {
            RoleAuthorityGetReqVo roleAuthorityGetReqVo = new RoleAuthorityGetReqVo();
            roleAuthorityGetReqVo.setRoleId(userRoleVo.getRoleId());
            List<RoleAuthorityVo> roleAuthorityVos = roleAuthorityDao.loadList(roleAuthorityGetReqVo,RoleAuthorityVo.class);
            roleAuthorityVoList.addAll(roleAuthorityVos);
        }
        if (null == roleAuthorityVoList || roleAuthorityVoList.isEmpty()){
            throw new CodeException("暂无权限");
        }
        List<AuthorityVo> authorityVoList = new ArrayList();
        for (RoleAuthorityVo roleAuthorityVo:roleAuthorityVoList) {
            AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
            authorityGetReqVo.setId(roleAuthorityVo.getAuthorityId());
            AuthorityVo authorityVo = authorityDao.load(authorityGetReqVo,AuthorityVo.class);
            if (authorityVo != null){
                authorityVoList.add(authorityVo);
            }
        }
        if (null == authorityVoList || authorityVoList.isEmpty()){
            throw new CodeException("暂无权限");
        }
        List<AuthorityListByLevelResVo> resVoList = new ArrayList();
        for (AuthorityVo authorityVo:authorityVoList) {
            AuthorityListByLevelResVo resVo = new AuthorityListByLevelResVo();
            ObjectHelper.writeWithFrom(resVo,authorityVo);
            List<AuthorityListByLevelResVo> childList = getChildList(authorityVo.getId());
            resVo.setChildList(childList);
            resVoList.add(resVo);
        }
        return resVoList;
    }
}
