package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.cloudvo.LoginResVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.reqvo.CompanyGetReqVo;
import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.UserService;
/*import com.yanzuoguang.token.TokenHelper;*/
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    CompanyDao companyDaoImpl;
    @Autowired
    UserDao userDaoImpl;
    @Autowired
    UserService userServiceImpl;
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    CompanyBankCardDao companyBankCardDaoImpl;

    @Override
    public Boolean checkMerchantId(String merchantId) {
        CompanyGetReqVo reqVo = new CompanyGetReqVo();
        reqVo.setId(merchantId);
        CompanyVo companyVo = companyDaoImpl.load(reqVo,CompanyVo.class);
        return companyVo == null ? false : true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyVo saveUser(RegisterUserReqVo registerUserReqVo) {
        if (registerUserReqVo.getCompanyType() != 0){
            throw new CodeException("目前仅支持个体用户");
        }

        userServiceImpl.isValid(registerUserReqVo.getAccount());

        UserVo userVo = new UserVo();
        userVo.setAccount(registerUserReqVo.getAccount());
        userServiceImpl.checkAccount(userVo);

        if (!registerUserReqVo.getPassword().equals(registerUserReqVo.getConfirmPassword())){
            throw new CodeException("确认密码错误");
        }

        String merchantId = registerUserReqVo.getMerchantId();
        if (!this.checkMerchantId(merchantId)){
            throw new CodeException("注册编码错误");
        }

        String companyId = StringHelper.getNewID();
        userVo.setPassword(StringHelper.md5(registerUserReqVo.getPassword()));
        userVo.setId(StringHelper.getNewID());
        userVo.setRemark(registerUserReqVo.getPassword());
        userVo.setCompanyId(companyId);
        userDaoImpl.create(userVo);
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(companyId);
        companyVo.setMerchantId(merchantId);
        companyVo.setCompanyType(registerUserReqVo.getCompanyType());

        return companyVo;
    }

    @Override
    public void checkPhone(String contactPhone) {
        CompanyVo companyVo = new CompanyVo();
        companyVo.setContactPhone(contactPhone);
        companyDaoImpl.checkPhone(companyVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveIndividual(RegisterIndividualReqVo reqVo) {
        CompanyVo companyVo = new CompanyVo();
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        CompanyExtendVo extendVo = new CompanyExtendVo();
        this.checkPhone(reqVo.getContactPhone());

        companyVo.setId(reqVo.getId());
        companyVo.setMerchantId(reqVo.getMerchantId());
        companyVo.setCompanyType(reqVo.getCompanyType());
        companyVo.setContactName(reqVo.getContactName());
        companyVo.setContactCode(reqVo.getContactCode());
        companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyVo.setContactPhone(reqVo.getContactPhone());
        companyVo.setCompanyName(reqVo.getExtraChoseOne());

        extendVo.setId(reqVo.getId());

        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setId(StringHelper.getNewID());

        int vehicle = 5;
        if (reqVo.getCompanyAttribute() == vehicle){
            companyVo.setBusinessLicenseCode(reqVo.getExtraChoseTwo());
        }else {
            companyVo.setAddress(reqVo.getExtraChoseTwo());
        }

        companyDaoImpl.create(companyVo);
        companyExtendDaoImpl.create(extendVo);
        companyBankCardDaoImpl.create(companyBankCardVo);

        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);
//        此处需要保存部分数据到merchant表中
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveEnterprise(RegisterEnterpriceReqVo reqVo) {
        CompanyVo companyVo = new CompanyVo();
        CompanyExtendVo extendVo = new CompanyExtendVo();
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        this.checkPhone(reqVo.getContactPhone());

        companyVo.setId(reqVo.getId());
        companyVo.setMerchantId(reqVo.getMerchantId());
        companyVo.setCompanyType(reqVo.getCompanyType());
        companyVo.setCompanyName(reqVo.getCompanyName());
        companyVo.setAddress(reqVo.getCompanyAddress());
        companyVo.setBusinessLicenseCode(reqVo.getBusinessLicenseCode());
        companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyVo.setContactName(reqVo.getContactName());
        companyVo.setContactCode(reqVo.getContactCode());
        companyVo.setContactPhone(reqVo.getContactPhone());

        extendVo.setId(reqVo.getId());

        companyBankCardVo.setId(StringHelper.getNewID());
        companyBankCardVo.setCompanyId(reqVo.getId());
        companyBankCardVo.setBankName(reqVo.getBankName());
        companyBankCardVo.setBankCardCode(reqVo.getBankCardCode());
        companyBankCardVo.setBankAddress(reqVo.getBankAddress());
        companyBankCardVo.setBankCode(reqVo.getBankCode());
        companyBankCardVo.setReservedPhone(reqVo.getReservedPhone());

        companyDaoImpl.create(companyVo);
        companyExtendDaoImpl.create(extendVo);
        companyBankCardDaoImpl.create(companyBankCardVo);

        UserVo userReqVo = new UserVo();
        userReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userReqVo,UserVo.class);
        userVo.setPhone(reqVo.getContactPhone());
        userDaoImpl.update(userVo);
//        此处需要保存部分数据到merchant表中
    }

    @Override
    public void login(LoginReqVo reqVo) {
        String accountOrPhone = reqVo.getAccountOrPhone();
        UserVo userVo;
        if (userServiceImpl.isNumeric(accountOrPhone)){
            userVo = userServiceImpl.getUserByPhone(accountOrPhone);
        }else {
            userVo = userServiceImpl.getUserByAccount(accountOrPhone);
        }

        if (userVo == null){
            throw new CodeException("没有此用户");
        }

        if (!StringHelper.md5(reqVo.getPassword()).equals(userVo.getPassword())){
            throw new CodeException("用户名或密码错误");
        }

        CompanyVo companyReqVo = new CompanyVo();
        CompanyBankCardVo companyBankCardReqVo = new CompanyBankCardVo();
        CompanyExtendVo companyExtendReqVo = new CompanyExtendVo();

        companyReqVo.setId(userVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyReqVo,CompanyVo.class);
        companyBankCardReqVo.setCompanyId(userVo.getCompanyId());
        CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(companyBankCardReqVo,CompanyBankCardVo.class);
        companyExtendReqVo.setId(userVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendReqVo,CompanyExtendVo.class);

        LoginResVo resVo = new LoginResVo();
        resVo.setUserVo(userVo);
        resVo.setCompanyVo(companyVo);
        resVo.setCompanyBankCardVo(companyBankCardVo);
        resVo.setCompanyExtendVo(companyExtendVo);
//        此处需要获取对应的merchant表数据

        /*token内容暂时不能用，以后要改动*/
        /*String token = StringHelper.getNewID();
        TokenHelper.write(token,resVo);*/
    }
}
