package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.RegisterService;
import com.pangding.web.authority.service.VerifyCodeService;
import com.pangding.web.vo.system.req.LoginReqVo;
import com.pangding.web.vo.system.res.LoginResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * @Author zhangjinyao
 * @create 2019/5/23 10:49
 */
@RestController
@RequestMapping(value="login")
@Api(value = "用户登录类")
public class LoginController {
    @Autowired
    RegisterService registerServiceImpl;
    @Autowired
    VerifyCodeService verifyCodeServiceImpl;

    /**
     * 登陆，验证用户名或手机号，密码是否正确
     * 返回token,account,LoginCompanyResVo对象（id：公司id,status：公司状态,companyAttribute：属性,bankCardCodeList：绑定的银行卡数组）
     *
     * @param reqVo
     * @return
     */
    @ApiOperation(value ="登录", notes = "返回登录信息")
    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<LoginResVo> mobile(@RequestBody LoginReqVo reqVo) throws Exception {
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone",reqVo.getAccountOrPhone())
                .notBlankCheck("password",reqVo.getPassword())
                .checkException();
        return ResponseResult.result(registerServiceImpl.login(reqVo));
    }

    /*@RequestMapping(value = "/computer", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<LoginResVo> computer(@RequestBody ComputerLoginReqVo reqVo, HttpSession session,HttpServletRequest request){
        CheckerHelper.newInstance()
                .notBlankCheck("account or phone",reqVo.getAccountOrPhone())
                .notBlankCheck("password",reqVo.getPassword())
                .notBlankCheck("verifyCode",reqVo.getVerifyCode())
                .checkException();
        return ResponseResult.result(registerServiceImpl.verifyLogin(reqVo,session,request));
    }

    *//**
     * 获取验证码图片
     *
     * @param request
     * @param response
     * @throws IOException
     *//*
    @RequestMapping(value="/getImage",method= RequestMethod.GET,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult getImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        verifyCodeServiceImpl.getImage(request,response);
        return new ResponseResult();
    }*/
}
