package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.reqvo.CountByRoleReqVo;
import com.pangding.web.authority.vo.reqvo.ListUserReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetReqVo;
import com.pangding.web.authority.vo.reqvo.UserGetSuperAdminReqVo;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.pangding.web.vo.system.req.authority.UserReqVo;
import com.pangding.web.vo.system.req.authority.V2.QueryUserReqVo;
import com.pangding.web.vo.system.res.authority.UserResVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

/**
 * @author zhangjinyao
 */
public interface UserDao extends BaseDao {


    /**
     * 检查用户名是否存在
     *
     * @param account 账户名
     * @return UserVo对象
     */
    void checkAccount(UserVo account);

    /**
     * 查询用户是否存在
     * @param req
     * @return
     */
    UserResVo queryUser(UserReqVo req);

    /**
     * 获取用户分页对象
     *
     * @param reqVo
     * @return 用户分页对象
     */
    PageSizeData<UserVo> getUserVoList(QueryUserReqVo reqVo);

    UserVo getAdmin(UserGetSuperAdminReqVo reqVo);

    /**
     * 获取该公司该角色已分配的角色列表
     * @param reqVo 封装了公司id和权限id的请求对象
     * @return 用户列表
     */
    PageSizeData<UserVo> countByRole(CountByRoleReqVo reqVo);


    /**
     * 获取某角色下的用户数
     * @param req
     * @return
     */
    UserResVo countUserByRole(CountByRoleReqVo req);
}
