package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.dao.company.CompanyBankCardDao;
import com.pangding.web.authority.dao.company.CompanyDao;
import com.pangding.web.authority.dao.company.CompanyExtendDao;
import com.pangding.web.authority.mq.CompanyConsumer;
import com.pangding.web.authority.service.FinanceService;
import com.pangding.web.authority.vo.reqvo.CompanyExtendGetReqVo;
import com.pangding.web.authority.vo.reqvo.WithdrawalReqVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.pangding.web.constant.CompanyConstant;
import com.pangding.web.constant.report.ReportMqConstant;
import com.pangding.web.vo.order.pd.CapitalFlowVo;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.order.req.back.CashWithdrawalBackReqVo;
import com.pangding.web.vo.order.res.CapitalFlowListResVo;
import com.pangding.web.vo.order.res.CapitalFlowResVo;
import com.pangding.web.vo.order.tl.CashWithdrawalReqVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyMoneyVo;
import com.pangding.web.vo.system.pd.company.CompanyRuleVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.req.company.CompanyRuleReqVo;
import com.pangding.web.vo.system.req.company.UpdateCompanyMoneyReqVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.mq.service.MqService;
import com.yanzuoguang.mq.vo.req.MessageLogReqVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.CalcHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/18 20:01
 */
@Service
public class FinanceServiceImpl implements FinanceService {

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDao;
    @Autowired
    private CapitalFlowDao capitalFlowDao;
    @Autowired
    private CompanyMoneyDao companyMoneyDao;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private CompanyRuleDao companyRuleDao;
    @Autowired
    private CompanyConsumer companyConsumer;
    @Autowired
    private MqService mqService;


    @Override
    public WithdrawalResVo withdrawal(WithdrawalReqVo reqVo) {
        /*返回对象*/
        WithdrawalResVo resVo = new WithdrawalResVo();

        CompanyResVo extendVo = companyDao.load(reqVo.getCompanyId(), CompanyResVo.class);
        if (null == extendVo) {
            throw new CodeException("未查到该公司数据");
        }
        resVo.setWithdrawTotalCash(extendVo.getWithdrawTotalCash());
        resVo.setCompanyExtend(extendVo);

        CompanyBankCardReqVo companyBankCardReqVo = new CompanyBankCardReqVo();
        companyBankCardReqVo.setCompanyId(reqVo.getCompanyId());
        companyBankCardReqVo.setIsDefault(1);
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDao.loadList(companyBankCardReqVo, CompanyBankCardVo.class);
        if (null == companyBankCardVoList || companyBankCardVoList.isEmpty()) {
            throw new CodeException("该公司暂无银行卡信息，请添加");
        }
        resVo.setBankCardVoList(companyBankCardVoList);

        // 获取公司规则信息
        CompanyRuleReqVo companyRuleReqVo = new CompanyRuleReqVo();
        companyRuleReqVo.setCompanyId(extendVo.getId());
        List<CompanyRuleVo> companyRuleVoList = companyRuleDao.loadList(companyRuleReqVo, CompanyRuleVo.class);
        resVo.setCompanyRuleVoList(companyRuleVoList);
        return resVo;
    }

    /**
     * 查询订单列表
     *
     * @param req
     * @return
     */
    @Override
    public CapitalFlowListResVo findCapitalFlowList(CapitalFlowReqVo req) {
        CapitalFlowListResVo capitalFlowListResVo = new CapitalFlowListResVo();
        if (!StringHelper.isEmpty(req.getStartDate())) {
            req.setStartDate(req.getStartDate() + " 00:00:00");
        }
        if (!StringHelper.isEmpty(req.getEndDate())) {
            req.setEndDate(req.getEndDate() + " 23:59:59");
        }

        PageSizeData<CapitalFlowResVo> pageSizeData = capitalFlowDao.findCapitalFlowList(req);

        CapitalFlowResVo capitalFlowTotal = capitalFlowDao.findCapitalFlowTotal(req);

        capitalFlowListResVo.setCapitalFlowResVoPageSizeData(pageSizeData);
        capitalFlowListResVo.setCapitalFlowResVo(capitalFlowTotal);
        return capitalFlowListResVo;
    }

    @Override
    public List<CapitalFlowResVo> findCapitalFlowListGroup(CapitalFlowReqVo req) {

        List<CapitalFlowResVo> capitalFlowTotal = capitalFlowDao.findCapitalFlowTotalList(req);

        return capitalFlowTotal;
    }

    @Override
    public CapitalFlowResVo findCapitalFlow(CapitalFlowReqVo req) {

        CapitalFlowResVo capitalFlowResVo = capitalFlowDao.load(req, CapitalFlowResVo.class);

        return capitalFlowResVo;
    }

    /**
     * 申请提现
     *
     * @param req
     * @return
     */
//    @Override
    public ResponseResult<CapitalFlowReqVo> applyWithdrawalbak(CapitalFlowReqVo req) {
        // 查找公司信息，提现信息
        CompanyResVo companyResVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        // 查询银行卡信息
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(req.getBankId(), CompanyBankCardVo.class);
        if (StringHelper.isEmpty(companyResVo) || StringHelper.isEmpty(companyBankCardVo)) {
            throw new CodeException("未找到公司信息");
        }
        // 提现手续费
        double withdrawFee = companyResVo.getWithdrawFee();
        // 可提现余额
        double withdrawTotalCash = companyResVo.getWithdrawTotalCash();
        if (withdrawTotalCash < req.getOrderMoney()) {
            throw new CodeException("提现金额不能大于可提现余额");
        }
        if (companyResVo.getMinWithdrawMoney() > req.getOrderMoney() || companyResVo.getMaxWithdrawMoney() < req.getOrderMoney()) {
            throw new CodeException("提现金额必须在范围内");
        }
        // 该公司有优惠
        if (1 == companyResVo.getDiscountRule()) {
            // 查询公司提现规则信息
            CompanyRuleReqVo companyRuleReqVo = new CompanyRuleReqVo();
            companyRuleReqVo.setCompanyId(companyResVo.getId());
            List<CompanyRuleVo> companyRuleVoList = companyRuleDao.loadList(companyRuleReqVo, CompanyRuleVo.class);
            for (int i = 0; i < companyRuleVoList.size(); i++) {
                CompanyRuleVo companyRuleVo = companyRuleVoList.get(i);
                int dateType = companyRuleVo.getDateType();
                int minNum = companyRuleVo.getMinNum();
                int maxNum = companyRuleVo.getMaxNum();
                // 获取提现笔数
                int withdrawNum = findWithdrawNum(companyResVo.getId(), dateType);
                // 判断总提现笔数在哪个优惠区间
                if (minNum <= withdrawNum && withdrawNum <= maxNum) {
                    withdrawFee = companyRuleVo.getWithdrawFee();
                    break;
                }
            }
        }
        CapitalFlowVo capitalFlowVo = new CapitalFlowVo();
        ObjectHelper.writeWithFrom(capitalFlowVo, req);
        capitalFlowVo.setOrderId(StringHelper.getNewID());
        capitalFlowVo.setCategory(1);
        capitalFlowVo.setOrderFee(withdrawFee);
        capitalFlowVo.setActualMoney(req.getOrderMoney() - capitalFlowVo.getOrderFee());
        capitalFlowVo.setTime(DateHelper.getNow());
        capitalFlowVo.setStatus(0);
        capitalFlowDao.save(capitalFlowVo);
        CashWithdrawalReqVo cashWithdrawalReqVo = new CashWithdrawalReqVo();
        ObjectHelper.writeWithFrom(cashWithdrawalReqVo, capitalFlowVo);
        cashWithdrawalReqVo.setActualType(companyResVo.getWithdrawType());
        cashWithdrawalReqVo.setBankCardType(companyBankCardVo.getType());
        companyConsumer.cashWithdrawal(cashWithdrawalReqVo);
        ResponseResult<CapitalFlowReqVo> responseResult = new ResponseResult<>();
        responseResult.setData(req);
        return responseResult;

    }

    /**
     * 申请提现
     *
     * @param req
     * @return
     */
    @Transactional
    @Override
    public ResponseResult<CapitalFlowReqVo> applyWithdrawal(CapitalFlowReqVo req) {
        // 先修改公司余额
        UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
        updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
        updateCompanyMoneyReqVo.setNewWithdrawTotalCash(0d);
        updateCompanyMoneyReqVo.setFrozenMoney(req.getOrderMoney());
        companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);

        // 查找公司信息，提现信息
        CompanyResVo companyResVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        // 查询银行卡信息
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(req.getBankId(), CompanyBankCardVo.class);
        if (StringHelper.isEmpty(companyResVo) || StringHelper.isEmpty(companyBankCardVo)) {
            throw new CodeException("未找到公司信息");
        }
        // 可提现余额
        double withdrawTotalCash = companyResVo.getWithdrawTotalCash();
        double frozenMoney = companyResVo.getFrozenMoney();
        double money = CalcHelper.sub(withdrawTotalCash, frozenMoney);

        //CalcHelper.sub(money, req.getOrderMoney())
        if (money < 0) {
            throw new CodeException("提现金额不能大于可提现余额");
        }
        if (companyResVo.getMinWithdrawMoney() > req.getOrderMoney() || companyResVo.getMaxWithdrawMoney() < req.getOrderMoney()) {
            throw new CodeException("提现金额必须在范围内");
        }
        // 提现手续费
        double withdrawFee = getWithdrawFee(companyResVo);
        // 滞纳金
        double lateFee = StringHelper.isEmpty(companyResVo.getLateFee()) ? 0 : companyResVo.getLateFee();

        // 系统手续费
        double serviceCharge = getServiceCharge1(companyResVo, req.getOrderMoney());

        double payServiceCharge = CalcHelper.add(lateFee, serviceCharge);

        double actualMoney = CalcHelper.sub(req.getOrderMoney(), CalcHelper.add(withdrawFee, payServiceCharge));

        CapitalFlowVo capitalFlowVo = new CapitalFlowVo();
        ObjectHelper.writeWithFrom(capitalFlowVo, req);
        capitalFlowVo.setOrderId(StringHelper.getNewID());
        capitalFlowVo.setCategory(1);
        capitalFlowVo.setOrderFee(withdrawFee);
        capitalFlowVo.setServiceCharge(payServiceCharge);
        capitalFlowVo.setActualMoney(actualMoney);
        capitalFlowVo.setTime(DateHelper.getNow());
        capitalFlowVo.setStatus(0);
        capitalFlowDao.save(capitalFlowVo);
        CashWithdrawalReqVo cashWithdrawalReqVo = new CashWithdrawalReqVo();
        ObjectHelper.writeWithFrom(cashWithdrawalReqVo, capitalFlowVo);
        cashWithdrawalReqVo.setActualType(companyResVo.getWithdrawType());
        cashWithdrawalReqVo.setBankCardType(companyBankCardVo.getType());
        cashWithdrawalReqVo.setOrderFee(CalcHelper.sub(capitalFlowVo.getOrderFee(), capitalFlowVo.getServiceCharge()));
        companyConsumer.cashWithdrawal(cashWithdrawalReqVo);
        ResponseResult<CapitalFlowReqVo> responseResult = new ResponseResult<>();
        responseResult.setData(req);
        // TODO 设置提现到账时间为1个小时，未到账则会写可提现余额
        return responseResult;

    }

    public double getServiceCharge(CompanyResVo companyResVo) {
        double serviceCharge = 0d;
        if (1 == companyResVo.getServiceChargeStatus()) {
            // 有服务费
            switch (companyResVo.getServiceChargeType()) {
                case 0:
                    serviceCharge = companyResVo.getServiceCharge();
                    break;
                case 1:
                    if (DateHelper.compare(DateHelper.getDateTime(DateHelper.getDayStart(DateHelper.getCurDate())),
                            DateHelper.getDateTime(DateHelper.getMonthStart(DateHelper.getCurDate()))) == 0) {
                        serviceCharge = companyResVo.getServiceCharge();
                    }
                    break;
                case 2:
                    if (DateHelper.compare(DateHelper.getDateTime(DateHelper.getDayStart(DateHelper.getCurDate())),
                            DateHelper.getDateTime(DateHelper.getYearStart(DateHelper.getCurDate()))) == 0) {
                        serviceCharge = companyResVo.getServiceCharge();
                    }
                    break;
                default:
                    break;
            }
        }
        return serviceCharge;
    }

    /**
     * 获取提现手续费
     *
     * @param companyResVo
     * @return
     */
    public Double getServiceCharge1(CompanyResVo companyResVo, double money) {
        // 提现手续费
        double serviceCharge = 0d;
        if (0 == companyResVo.getServiceChargeStatus()) {
            // 无手续费
            return serviceCharge;
        }
        // 该公司有优惠
        switch (companyResVo.getServiceChargePayType()) {
            case 1:
                // 提现扣除
                int serviceChargeMoneyType = companyResVo.getServiceChargeMoneyType();
                if (0 == serviceChargeMoneyType) {
                    // 固定值
                    serviceCharge = companyResVo.getServiceCharge();
                } else {
                    // 提现金额的比例
                    serviceCharge = CalcHelper.mul(money, companyResVo.getServiceCharge());
                }
                break;
            default:
                break;
        }
        serviceCharge = Math.round(serviceCharge * 100) / 100.0;
        return serviceCharge;
    }


    /**
     * 获取提现手续费
     *
     * @param companyResVo
     * @return
     */
    public Double getWithdrawFee(CompanyResVo companyResVo) {
        // 提现手续费
        double withdrawFee = companyResVo.getWithdrawFee();
        // 该公司有优惠
        switch (companyResVo.getDiscountRule()) {
            case 1:
                CompanyRuleReqVo companyRuleReqVo = new CompanyRuleReqVo();
                companyRuleReqVo.setCompanyId(companyResVo.getId());
                List<CompanyRuleVo> companyRuleVoList = companyRuleDao.loadList(companyRuleReqVo, CompanyRuleVo.class);
                for (int i = 0; i < companyRuleVoList.size(); i++) {
                    CompanyRuleVo companyRuleVo = companyRuleVoList.get(i);
                    // 获取提现笔数
                    int withdrawNum = findWithdrawNum(companyResVo.getId(), companyRuleVo.getDateType());
                    // 判断总提现笔数在哪个优惠区间
                    if (companyRuleVo.getMinNum() <= withdrawNum && withdrawNum < companyRuleVo.getMaxNum()) {
                        withdrawFee = companyRuleVo.getWithdrawFee();
                        break;
                    }
                }
                break;
            default:
                break;
        }
        return withdrawFee;
    }


    public int findWithdrawNum(String companyId, int dateType) {
        CapitalFlowReqVo capitalFlowReqVo = new CapitalFlowReqVo();
        capitalFlowReqVo.setCompanyId(companyId);
        capitalFlowReqVo.setStatus(1);
        capitalFlowReqVo.setCategory(1);
        // 判断优惠按什么维度优惠
        switch (dateType) {
            case 0:
                //  按天
                capitalFlowReqVo.setStartDate(DateHelper.getDateTimeString(DateHelper.getDayStart(DateHelper.getCurDate())));
                capitalFlowReqVo.setEndDate(DateHelper.getDateTimeString(DateHelper.getDayEnd(DateHelper.getCurDate())));
                break;
            case 1:
                // 按月
                capitalFlowReqVo.setStartDate(DateHelper.getDateTimeString(DateHelper.getMonthStart(DateHelper.getCurDate())));
                capitalFlowReqVo.setEndDate(DateHelper.getDateTimeString(DateHelper.getMonthEnd(DateHelper.getCurDate())));
                break;
            case 2:
                // 按年
                capitalFlowReqVo.setStartDate(DateHelper.getDateTimeString(DateHelper.getYearStart(DateHelper.getCurDate())));
                capitalFlowReqVo.setEndDate(DateHelper.getDateTimeString(DateHelper.getYearEnd(DateHelper.getCurDate())));
                break;
            default:
                break;
        }
        CapitalFlowResVo capitalFlowResVo = capitalFlowDao.findCapitalFlowTotal(capitalFlowReqVo);
        int withdrawNum = 0;
        if (!StringHelper.isEmpty(capitalFlowResVo)) {
            withdrawNum = capitalFlowResVo.getNum();
        }
        return withdrawNum;
    }

    /**
     * 提现回调
     *
     * @param req
     */
    @Transactional
//    @Override
    public ResponseResult<String> withdrawalBackbak(CashWithdrawalBackReqVo req) {
        CapitalFlowVo capitalFlowVo = capitalFlowDao.load(req.getId(), CapitalFlowVo.class);
        if (!StringHelper.isEmpty(capitalFlowVo)) {
            capitalFlowVo.setStatus(req.getStatus());
            capitalFlowVo.setErrorMessage(req.getErrorMessage());
            capitalFlowVo.setTonglianId(req.getTonglianId());
            capitalFlowVo.setTime(DateHelper.getNow());
            if (1 == req.getStatus()) {
                // 修改公司金额
                UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
                updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
                updateCompanyMoneyReqVo.setNewWithdrawTotalCash(-capitalFlowVo.getOrderMoney());
                companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);

                CompanyResVo companyResVo = companyDao.load(capitalFlowVo.getCompanyId(), CompanyResVo.class);
                if (!StringHelper.isEmpty(companyResVo)) {
                    double oldMoney = companyResVo.getWithdrawTotalCash() + capitalFlowVo.getOrderMoney();
                    double newMoney = oldMoney - capitalFlowVo.getOrderMoney();
                    capitalFlowVo.setInitMoney(oldMoney);
                    capitalFlowVo.setFinalMoney(newMoney);
                    saveCompanyMoney(capitalFlowVo, companyResVo, oldMoney);
                }
            }
            capitalFlowDao.update(capitalFlowVo);
        } else {
            throw new CodeException("订单信息错误。");
        }
        return ResponseResult.result("");
    }

    /**
     * 提现回调
     *
     * @param req
     */
    @Transactional
    @Override
    public ResponseResult<String> withdrawalBack(CashWithdrawalBackReqVo req) {
        CapitalFlowVo capitalFlowVo = capitalFlowDao.load(req.getId(), CapitalFlowVo.class);
        if (!StringHelper.isEmpty(capitalFlowVo)) {
            capitalFlowVo.setStatus(req.getStatus());
            capitalFlowVo.setErrorMessage(req.getErrorMessage());
            capitalFlowVo.setTonglianId(req.getTonglianId());
            capitalFlowVo.setTime(DateHelper.getNow());
            if (1 == req.getStatus()) {
                // 修改公司金额
                UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
                updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
                updateCompanyMoneyReqVo.setFrozenMoney(-capitalFlowVo.getOrderMoney());
                updateCompanyMoneyReqVo.setNewWithdrawTotalCash(-capitalFlowVo.getOrderMoney());
//    todo...2021.10.9被注释            updateCompanyMoneyReqVo.setLateFee(-capitalFlowVo.getServiceCharge());
                companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);

                CompanyResVo companyResVo = companyDao.load(capitalFlowVo.getCompanyId(), CompanyResVo.class);
                if (!StringHelper.isEmpty(companyResVo)) {
                    double oldMoney = companyResVo.getWithdrawTotalCash() + capitalFlowVo.getOrderMoney();
                    double newMoney = oldMoney - capitalFlowVo.getOrderMoney();
                    capitalFlowVo.setInitMoney(oldMoney);
                    capitalFlowVo.setFinalMoney(newMoney);
                    saveCompanyMoney(capitalFlowVo, companyResVo, oldMoney);
                }
            } else {
                // 修改公司金额 提现失败 余额冲正
                UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
                updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
                updateCompanyMoneyReqVo.setNewWithdrawTotalCash(0d);
                updateCompanyMoneyReqVo.setFrozenMoney(-capitalFlowVo.getOrderMoney());
//                updateCompanyMoneyReqVo.setLateFee(capitalFlowVo.getOrderFee());
                companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);
            }
            capitalFlowDao.update(capitalFlowVo);
        } else {
            throw new CodeException("订单信息错误。");
        }
        return ResponseResult.result("");
    }

    /**
     * 转账
     *
     * @param req
     */
    public String divideSettlement(CapitalFlowReqVo req) {
        CashWithdrawalReqVo cashWithdrawalReqVo = new CashWithdrawalReqVo();
        ObjectHelper.writeWithFromClass(cashWithdrawalReqVo, req);
        capitalFlowDao.create(req);
        companyConsumer.divideSettlement(cashWithdrawalReqVo);
        return "处理成功";
    }

    /**
     * 转账回调
     *
     * @param req
     */
    @Transactional
    @Override
    public ResponseResult<String> divideSettlementBack(CashWithdrawalBackReqVo req) {
        CapitalFlowVo capitalFlowVo = capitalFlowDao.load(req.getId(), CapitalFlowVo.class);
        if (!StringHelper.isEmpty(capitalFlowVo)) {
            capitalFlowVo.setStatus(req.getStatus());
            capitalFlowVo.setErrorMessage(req.getErrorMessage());
            capitalFlowVo.setTonglianId(req.getTonglianId());
            capitalFlowVo.setTime(DateHelper.getNow());
            if (1 == req.getStatus()) {
                // 修改公司金额
                UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
                updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
                updateCompanyMoneyReqVo.setNewWithdrawTotalCash(capitalFlowVo.getActualMoney());
                companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);

                CompanyResVo companyResVo = companyDao.load(capitalFlowVo.getCompanyId(), CompanyResVo.class);
                if (!StringHelper.isEmpty(companyResVo)) {
                    double oldMoney = companyResVo.getWithdrawTotalCash() - capitalFlowVo.getActualMoney();
                    double newMoney = oldMoney + capitalFlowVo.getActualMoney();
                    capitalFlowVo.setInitMoney(oldMoney);
                    capitalFlowVo.setFinalMoney(newMoney);
                    saveCompanyMoney(capitalFlowVo, companyResVo, oldMoney);
                }
            }
            capitalFlowDao.update(capitalFlowVo);
        } else {
            throw new CodeException("订单信息错误。");
        }
        return ResponseResult.result("");
    }

    @Transactional
    @Override
    public ResponseResult<String> saveCapitalFlow(CapitalFlowReqVo req) {
        req.setTempId(StringHelper.getMD5Id(req.getOrderId(), req.getOrderMonetDetailId()));
        mqService.log(new MessageLogReqVo(ReportMqConstant.REPORT_PRODUCT_DETAIL_SAVE, req.getTempId()));
        double money = req.getActualMoney();
        if (CompanyConstant.CATEGORY_REFUND == req.getCategory()) {
            // 退款
            if (money == 0) {
                money = 0;
            } else {
                money = -money;
            }
        }
        if (StringHelper.isEmpty(money)) {
            throw new CodeException("金额不能为空");
        }
        //修改公司余额
        UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo = new UpdateCompanyMoneyReqVo();
        updateCompanyMoneyReqVo.setCompanyId(req.getCompanyId());
        updateCompanyMoneyReqVo.setNewWithdrawTotalCash(money);
        companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);


        CompanyResVo companyVo = companyDao.load(req.getCompanyId(), CompanyResVo.class);
        if (StringHelper.isEmpty(companyVo)) {
            throw new CodeException("未找到公司信息");
        }
//        double realMoney = CalcHelper.sub(companyVo.getWithdrawTotalCash(), companyVo.getFrozenMoney());
        double oldMoney = companyVo.getWithdrawTotalCash() - money;
        // 添加资金流水
        String id = StringHelper.getMD5Id(req.getOrderId(), req.getOrderMonetDetailId(), req.getCompanyId());
//        CapitalFlowReqVo capitalFlowReqVo = new CapitalFlowReqVo();
//        capitalFlowReqVo.setOrderId(req.getOrderId());
        CapitalFlowVo capitalFlowVo = capitalFlowDao.load(id, CapitalFlowVo.class);
        if (StringHelper.isEmpty(capitalFlowVo)) {
            capitalFlowVo = new CapitalFlowVo();
            ObjectHelper.writeWithFrom(capitalFlowVo, req);
            capitalFlowVo.setId(id);
            capitalFlowVo.setStatus(1);
            capitalFlowVo.setTime(DateHelper.getNow());
            capitalFlowVo.setActualMoney(money);
            capitalFlowVo.setInitMoney(oldMoney);
            capitalFlowVo.setFinalMoney(capitalFlowVo.getActualMoney() + capitalFlowVo.getInitMoney());
            capitalFlowDao.create(capitalFlowVo);
        } else {
            ObjectHelper.writeWithFrom(capitalFlowVo, req);
            capitalFlowVo.setStatus(1);
            capitalFlowVo.setTime(DateHelper.getNow());
            capitalFlowVo.setActualMoney(money);
            capitalFlowVo.setInitMoney(oldMoney);
            capitalFlowVo.setFinalMoney(capitalFlowVo.getActualMoney() + capitalFlowVo.getInitMoney());
            capitalFlowDao.update(capitalFlowVo);
        }
        saveCompanyMoney(capitalFlowVo, companyVo, oldMoney);
        return ResponseResult.result("处理完成");
    }

    @Override
    public void updateCompanyMoney(UpdateCompanyMoneyReqVo updateCompanyMoneyReqVo) {
        companyExtendDao.updateCompanyMoney(updateCompanyMoneyReqVo);
    }


    public void saveCompanyMoney(CapitalFlowVo capitalFlowVo, CompanyResVo companyVo, double initMoney) {
        //修改公司余额
        double oldMoney = initMoney;
        double inMoney = 0d, outMoney = 0d, refundMoney = 0d, divideMoney = 0d;
        int inNumber = 0, outNumber = 0, refundNumber = 0, divideNumber = 0;
        if (CompanyConstant.CATEGORY_ENTRY == capitalFlowVo.getCategory()
                || CompanyConstant.CATEGORY_RECHARGE == capitalFlowVo.getCategory()) {
            // 交易订单金额 充值 分润
            inNumber = 1;
            inMoney = capitalFlowVo.getActualMoney();
        }
        if (capitalFlowVo.getCategory() >= 4 && capitalFlowVo.getCategory() <= 10) {
            // 分润
            divideNumber = 1;
            divideMoney = capitalFlowVo.getActualMoney();
        }
        if (CompanyConstant.CATEGORY_REFUND == capitalFlowVo.getCategory()) {
            // 退款
            refundNumber = 1;
            refundMoney = capitalFlowVo.getActualMoney();
        }
        if (CompanyConstant.CATEGORY_WITHDRAWAL == capitalFlowVo.getCategory()) {
            // 提现
            outNumber = 1;
            outMoney = -capitalFlowVo.getOrderMoney();
        }
        CompanyMoneyVo companyMoneyReqVo = new CompanyMoneyVo();
        companyMoneyReqVo.setDailyDate(DateHelper.getToday());
        companyMoneyReqVo.setCompanyId(companyVo.getId());
        CompanyMoneyVo companyMoneyVo = companyMoneyDao.load(companyMoneyReqVo, CompanyMoneyVo.class);
        if (StringHelper.isEmpty(companyMoneyVo)) {
            companyMoneyVo = new CompanyMoneyVo();
            companyMoneyVo.setCompanyMoneyId(StringHelper.getNewID());
            companyMoneyVo.setCompanyId(companyVo.getId());
            companyMoneyVo.setDailyDate(DateHelper.getToday());
            companyMoneyVo.setCompanyName(companyVo.getCompanyName());
            companyMoneyVo.setInitMoney(oldMoney);
            companyMoneyVo.setInNumber(inNumber);
            companyMoneyVo.setInMoney(inMoney);
            companyMoneyVo.setOutNumber(outNumber);
            companyMoneyVo.setOutMoney(outMoney);
            companyMoneyVo.setRefundNumber(refundNumber);
            companyMoneyVo.setRefundMoney(refundMoney);
            companyMoneyVo.setDivideNumber(divideNumber);
            companyMoneyVo.setDivideMoney(divideMoney);
            companyMoneyVo.setFinalMoney(companyMoneyVo.getInitMoney() + companyMoneyVo.getInMoney() + companyMoneyVo.getDivideMoney()
                    + companyMoneyVo.getOutMoney() + companyMoneyVo.getRefundMoney());
            companyMoneyDao.create(companyMoneyVo);
        } else {
            companyMoneyVo.setInNumber(inNumber);
            companyMoneyVo.setInMoney(inMoney);
            companyMoneyVo.setDivideNumber(divideNumber);
            companyMoneyVo.setDivideMoney(divideMoney);
            companyMoneyVo.setOutNumber(outNumber);
            companyMoneyVo.setOutMoney(outMoney);
            companyMoneyVo.setRefundNumber(refundNumber);
            companyMoneyVo.setRefundMoney(refundMoney);
            companyMoneyDao.updateCompanyMoney(companyMoneyVo);
        }
        if (0 == companyVo.getActivationStatus() && 1 == companyVo.getExamineStatus()) {
            // 公司未激活 激活公司
            companyConsumer.cmpanyActiviat(companyVo);
        }
        if (1 == companyVo.getActivationStatus() && 1 == companyVo.getExamineStatus()) {
            // 公司激活状态 审核通过状态 公司邀请奖励
            companyVo.setRewardType(CompanyConstant.CATEGORY_ACTIVATION_SALE_BONUS);
            companyConsumer.companyReward(companyVo);
        }
    }

}
