package com.pangding.web.authority.controller.company;


import com.pangding.web.authority.service.company.CompanyTollPointService;
import com.pangding.web.vo.system.pd.company.CompanyTollPointVo;
import com.pangding.web.vo.system.req.company.CompanyTollPointReqVo;
import com.pangding.web.vo.system.res.company.CompanyTollPointResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping(value = "/companyTollPoint", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "公司收费点相关类", description = "收费点新增、修改、删除等操作")
public class CompanyTollPointController {

    private CompanyTollPointService companyTollPointService;

    public CompanyTollPointController(CompanyTollPointService companyTollPointService) {
        this.companyTollPointService = companyTollPointService;
    }

    @RequestMapping(value = "/queryPageList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询收费点列表", notes = "返回公司收费点列表信息")
    public ResponseResult<PageSizeData<CompanyTollPointResVo>> queryPageList(@RequestBody CompanyTollPointReqVo req) {
        return ResponseResult.result(companyTollPointService.queryPageList(req));
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询收费点列表", notes = "返回公司收费点列表信息")
    public ResponseResult<List<CompanyTollPointVo>> queryList(@RequestBody CompanyTollPointReqVo req) {
        return ResponseResult.result(companyTollPointService.queryList(req));
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "保存公司收费点", notes = "返回公司收费点信息")
    public ResponseResult<CompanyTollPointVo> save(@RequestBody CompanyTollPointReqVo req) {
        return ResponseResult.result(companyTollPointService.save(req));
    }

    @RequestMapping(value = "/queryCompanyTollPoint", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "查询公司收费点详情", notes = "返回公司收费点详情")
    public ResponseResult<CompanyTollPointVo> queryCompanyTollPoint(@RequestBody CompanyTollPointReqVo req) {
        return ResponseResult.result(companyTollPointService.queryCompanyTollPoint(req));
    }


    @RequestMapping(value = "/delCompanyTollPoint", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "删除公司收费点", notes = "返回删除结果")
    public ResponseResult<String> delCompanyTollPoint(@RequestBody CompanyTollPointReqVo req) {
        companyTollPointService.delCompanyTollPoint(req);
        return ResponseResult.result("处理完成");
    }



}
