package com.pangding.web.authority.dao.code.Impl;

import com.pangding.web.authority.dao.code.CodeModelDao;
import com.pangding.web.vo.system.pd.code.CodeModelVo;
import com.pangding.web.vo.system.req.code.CodeModelReqVo;
import com.pangding.web.vo.system.res.code.CodeModelExtendResVo;
import com.pangding.web.vo.system.res.code.CodeModelResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CodeModelDaoImpl extends BaseDaoImpl implements CodeModelDao {

    // 查询列表
    private static final String QUERY_LIST = "QUERY_LIST";

    private static final String QUERY_LIST_EXTEND = "QUERY_LIST_EXTEND";


    @Override
    protected void init() {
        register(CodeModelVo.class);

        table.add(QUERY_LIST, "SELECT * FROM pd_code_model WHERE 1=1 ")
                .add("codeModelName","AND code_model_name LIKE concat('%', ?,'%')  ")
                .add("codeType","AND code_type = ? ");

        table.add(QUERY_LIST_EXTEND, "select a.*,b.code_model_extend_id,b.param_name,b.param_remark,b.param_sort " +
                " from pd_code_model a LEFT JOIN pd_code_model_extend b on a.code_model_id = b.code_model_id" +
                " WHERE 1=1 ")
                .add("codeModelName","AND code_model_name LIKE concat('%', ?,'%')  ")
                .add("codeType","AND code_type = ? ");

    }

    @Override
    public PageSizeData<CodeModelResVo> queryCodeModelPageList(CodeModelReqVo req) {
        return this.queryPage(CodeModelResVo.class, req, QUERY_LIST, req);
    }


    @Override
    public List<CodeModelResVo> queryCodeModelList(CodeModelReqVo req) {
        return this.query(CodeModelResVo.class, QUERY_LIST, req);
    }

    public List<CodeModelExtendResVo> querylList(CodeModelReqVo req) {
        return this.query(CodeModelExtendResVo.class, QUERY_LIST_EXTEND, req);
    }

}
