package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.feign.PayFeign;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.feign.WxFeign;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.service.PangdingPartnerService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.util.CompanyBankCardConstant;
import com.pangding.web.authority.util.CompanyConstant;
import com.pangding.web.authority.util.RsaConstant;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.*;
import com.pangding.web.util.RSAUtils;
import com.sun.org.apache.regexp.internal.RE;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.aspectj.apache.bcel.classfile.Code;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 */
@Service
public class CompanyServiceImpl implements CompanyService {

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private UserService userServiceImpl;
    @Autowired
    private UserDao userDaoImpl;
    @Autowired
    private PayFeign payFeign;
    @Autowired
    private StoreFeign storeFeign;
    @Autowired
    private WxFeign wxFeign;
    @Autowired
    private UserRoleDao userRoleDaoImpl;
    @Autowired
    private PangdingPartnerService pangdingPartnerServiceImpl;
    @Autowired
    private CompanyMsgDao companyMsgDao;
    @Autowired
    private CompanyDivideRuleDao companyDivideRuleDao;
    @Autowired
    private RoleDao roleDaoImpl;
    @Autowired
    private CompanyMoneyDetailDao companyMoneyDetailDao;

    /**
     * 修改公司信息
     *
     * @param companyVo
     */
    @Override
    public void updateCompanyStatus(CompanyVo companyVo) {
        CompanyVo company = companyDao.load(companyVo.getId(), CompanyVo.class);
        ObjectHelper.writeWithFrom(company, companyVo);
        companyDao.update(company);
    }

    /**
     * 分页查询公司信息
     *
     * @param reqVo 继承了分页对象
     * @return 公司列表分页对象
     */
    @Override
    public PageSizeData<CompanyVo> list(ListCompanyReqVo reqVo) {
        PageSizeData<CompanyVo> pageSizeData = companyDao.getCompanyList(reqVo);
        if (null == pageSizeData || null == pageSizeData.getList() || pageSizeData.getList().isEmpty()) {
            throw new CodeException("暂无公司信息");
        }
        return pageSizeData;
    }

    /**
     * 胖丁查询用户，公司和公司扩展表信息以及银行卡列表
     *
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司，公司扩展表和银行卡列表信息的对象
     */
    @Override
    public CompanyResVo pdGetDetail(CompanyGetReqVo reqVo) {
        CompanyResVo resVo = getDetail(reqVo);
        /*获取用户表信息*/
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setIsFirst(1);
        userGetReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null != userVo) {
            userVo.setPassword("");
            userVo.setRemark("");
            resVo.setUserVo(userVo);
        }else {
            UserGetReqVo userGetReqVo1 = new UserGetReqVo();
            userGetReqVo1.setCompanyId(reqVo.getId());
            UserVo userVo1 = userDaoImpl.load(userGetReqVo1,UserVo.class);
            resVo.setUserVo(userVo1);
        }
        /*获取没有公司id的角色数组*/
        GetEmptyRolesReqVo getEmptyRolesReqVo = new GetEmptyRolesReqVo();
        List<RoleVo> roleVoList = roleDaoImpl.getEmptyRoles(getEmptyRolesReqVo);
        /*if (null == roleVoList || roleVoList.isEmpty()){
            throw new CodeException("暂无未分配的角色，请先创建角色");
        }*/
        resVo.setRoleVoList(roleVoList);
        return resVo;
    }

    @Override
    public CompanyResVo getDetail(CompanyGetReqVo reqVo) {
        CompanyResVo resVo = new CompanyResVo();
        /*获取公司表信息*/
        CompanyVo companyVo = companyDao.load(reqVo, CompanyVo.class);
        if (null != companyVo) {
            resVo.setCompanyVo(companyVo);
        }

        /*此处需要根据公司id和productOrInterface获取商户信息*/
        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setProductOrInterface(companyVo.getProductOrInterface());
        companyScenicInfoReqVo.setReqId(reqVo.getReqId());
        try {
            ResponseResult result = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
            if (null != result && "00".equals(result.getCode())) {
                resVo.setMerchant((Merchant) result.getData());
            }
        } catch (Exception e) {
            resVo.setMerchant(null);
        }

        /*获取公司扩展表信息*/
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(reqVo.getId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendGetReqVo, CompanyExtendVo.class);
        if (null != companyExtendVo) {
            resVo.setCompanyExtendVo(companyExtendVo);
        }
        /*获取公司银行卡列表*/
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setCompanyId(reqVo.getId());
        companyBankCardGetReqVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(companyBankCardGetReqVo, CompanyBankCardVo.class);
        if (null != companyBankCardVo) {
            resVo.setBankCardVo(companyBankCardVo);
        }
        return resVo;
    }

    /**
     * 新增用户表（密码为123456），公司主表，公司扩展表，商户表，银行卡表（企业类型有，个人类型没有）
     *
     * @param reqVo 公司以及公司扩展表信息
     * @return 公司id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo saveCompany(SaveCompanyReqVo reqVo) {
        /*返回结果对象*/
        SaveCompanyResVo resVo = new SaveCompanyResVo();
        /*检查用户名*/
        if (null != reqVo.getAccount()){
            userServiceImpl.isValid(reqVo.getAccount());
            UserVo userReqVo = new UserVo();
            userReqVo.setAccount(reqVo.getAccount());
            if (null != reqVo.getUserId() && !reqVo.getUserId().isEmpty()) {
                userReqVo.setId(reqVo.getUserId());
            }
            userServiceImpl.checkAccount(userReqVo);
        }

        /*公司主表*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(reqVo.getCompanyId() != null?reqVo.getCompanyId():StringHelper.getNewID());
        ObjectHelper.writeWithFrom(companyVo, reqVo);
        companyVo.setAddress(reqVo.getCompanyAddress());
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo.setStatus(reqVo.getStatus() != null?reqVo.getStatus():0);
        companyVo.setExamineStatus(0);

        /*注册服务请求对象*/
        CompanyReqVo companyReqVo = new CompanyReqVo();
        companyReqVo.setBankList(new ArrayList<CompanyBankReqVo>());
        ObjectHelper.writeWithFrom(companyReqVo, companyVo);
        companyReqVo.setCompanyAttribution(reqVo.getCompanyAttribute());

        /*银行卡*/
        if (reqVo.getCompanyType() == 1) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            ObjectHelper.writeWithFrom(companyBankCardVo, reqVo);
            companyBankCardVo.setId(reqVo.getCompanyBankCardId()!=null?reqVo.getCompanyBankCardId():StringHelper.getNewID());
            companyBankCardVo.setName(reqVo.getContactName());
            companyBankCardVo.setPhone(reqVo.getContactPhone());
            companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
            companyBankCardVo.setType(reqVo.getCompanyType());
            companyBankCardVo.setIdCard(reqVo.getContactCode());
            companyBankCardVo.setCompanyId(companyVo.getId());

            CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
            ObjectHelper.writeWithFrom(companyBankReqVo, companyBankCardVo);
            companyReqVo.getBankList().add(companyBankReqVo);
        }
        /*注册*/
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("获取失败，请重试");
        }
        CompanyReqVo res = (CompanyReqVo) result.getData();
        CompanyVo companyVo1 = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo1,res);
        companyVo1.setProductOrInterface(companyVo.getProductOrInterface());
        companyVo1.setExamineStatus(companyVo.getExamineStatus());
        companyVo1.setCompanyAttribute(companyReqVo.getCompanyAttribution());

        /*保存公司主表*/
        if (reqVo.getCompanyId()!=null){
            companyDao.update(companyVo1);
        }else {
            companyDao.create(companyVo1);
        }

        resVo.setCompanyId(companyVo1.getId());
        resVo.setStatus(companyVo1.getStatus());

        /*保存银行卡表*/
        List<CompanyBankReqVo> companyBankReqVoList = res.getBankList();
        if (null != companyBankReqVoList && !companyBankReqVoList.isEmpty()) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            CompanyBankReqVo companyBankReqVo = companyBankReqVoList.get(0);
            ObjectHelper.writeWithFrom(companyBankCardVo, companyBankReqVo);
            companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);

            if (null != reqVo.getCompanyBankCardId()){
                companyBankCardDao.update(companyBankCardVo);
            }else {
                companyBankCardDao.create(companyBankCardVo);
            }

            resVo.setCompanyBankCardId(companyBankCardVo.getId());
        }

        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(companyVo.getId());
        String qrCode = DateHelper.getNow()
                .replace("-", "")
                .replace(":", "")
                .replace(" ", "");
        extendVo.setQrCode(qrCode);
        if (null != reqVo.getCompanyExtendId()){
            companyExtendDaoImpl.update(extendVo);
        }else {
            companyExtendDaoImpl.create(extendVo);
        }
        resVo.setCompanyExtendId(extendVo.getId());

        /*保存商户表*/
        MerchantCreateReqVo merchantCreateReqVo = new MerchantCreateReqVo();

        merchantCreateReqVo.setId(reqVo.getMerchantId()!=null?reqVo.getMerchantId():StringHelper.getNewID());
        merchantCreateReqVo.setType(reqVo.getCompanyAttribute());
        merchantCreateReqVo.setName(reqVo.getMerchantName());
        merchantCreateReqVo.setAddress(reqVo.getMerchantAddress());
        merchantCreateReqVo.setUserId(reqVo.getCreateId());
        merchantCreateReqVo.setUsername(reqVo.getCreateName());
        merchantCreateReqVo.setProductCompanyId(companyVo.getId());


        ResponseResult result1 = storeFeign.merchantCreate(merchantCreateReqVo);
        if (null == result1 || !"00".equals(result1.getCode())) {
            throw new CodeException("获取失败，请重试");
        }
        String merchantId = (String) result1.getData();
        resVo.setMerchantId(merchantId);

        /*保存用户*/
        UserVo userVo = new UserVo();
        userVo.setId(reqVo.getUserId()!=null?reqVo.getUserId():StringHelper.getNewID());
        userVo.setAccount(reqVo.getAccount());
        userVo.setPassword(StringHelper.md5("123456"));
        userVo.setRemark("123456");
        userVo.setName(reqVo.getContactName());
        userVo.setCreateId(reqVo.getCreateId());
        userVo.setCreateName(reqVo.getCreateName());
        userVo.setCompanyId(companyVo.getId());
        userVo.setPhone(reqVo.getContactPhone());
        userVo.setIsFirst(1);
        /*检查手机是否存在*/
        userServiceImpl.checkPhone(userVo);
        if (null!=reqVo.getUserId()){
            userDaoImpl.update(userVo);
        }else {
            userDaoImpl.create(userVo);
        }

        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 添加公司提交按钮
     *
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo companySubmit(SaveCompanyReqVo reqVo) {
        /*返回对象*/
        SaveCompanyResVo resVo = new SaveCompanyResVo();
        /*公司主表*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDao.load(companyGetReqVo, CompanyVo.class);
        companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyVo.setCompanyName(reqVo.getCompanyName());
        companyVo.setAddress(reqVo.getCompanyAddress());
        companyVo.setBusinessLicenseCode(reqVo.getBusinessLicenseCode());
        companyVo.setContactName(reqVo.getContactName());
        companyVo.setContactCode(reqVo.getContactCode());
        companyVo.setContactPhone(reqVo.getContactPhone());
        companyVo.setUpdateTime(DateHelper.getNow());

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyExtendId(companyVo.getId());
        /*注册请求对象*/
        CompanyReqVo companyReqVo = new CompanyReqVo();
        companyReqVo.setBankList(new ArrayList<CompanyBankReqVo>());
        ObjectHelper.writeWithFrom(companyReqVo, companyVo);
        if (null != reqVo.getVerifyCode() && !reqVo.getVerifyCode().isEmpty()) {
            companyReqVo.setValidateCode(reqVo.getVerifyCode());
        }
        companyReqVo.setId(reqVo.getId());

        /*银行卡*/
        if (null != reqVo.getCompanyBankCardId() && !reqVo.getCompanyBankCardId().isEmpty()) {
            CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
            companyBankCardGetReqVo.setId(reqVo.getCompanyBankCardId());
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(companyBankCardGetReqVo, CompanyBankCardVo.class);
            companyBankCardVo.setName(reqVo.getContactName());
            companyBankCardVo.setIdCard(reqVo.getContactCode());
            companyBankCardVo.setPhone(reqVo.getContactPhone());
            companyBankCardVo.setBankName(reqVo.getBankName());
            companyBankCardVo.setBankAddress(reqVo.getBankAddress());
            companyBankCardVo.setBankCardCode(reqVo.getBankCardCode());
            companyBankCardVo.setBankCode(reqVo.getBankCode());
            CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
            ObjectHelper.writeWithFrom(companyBankReqVo, companyBankCardVo);
            companyReqVo.getBankList().add(companyBankReqVo);

            resVo.setCompanyBankCardId(companyBankCardVo.getId());
        }

        /*注册服务验证验证码*/
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("验证失败，请重试");
        }

        /*更新公司主表*/
        CompanyReqVo res = (CompanyReqVo) result.getData();
        CompanyVo companyVo1 = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo1,res);
        companyVo1.setProductOrInterface(companyVo.getProductOrInterface());
        companyVo1.setExamineStatus(companyVo.getExamineStatus());
        companyVo1.setCompanyAttribute(companyVo.getCompanyAttribute());
        companyDao.update(companyVo1);

        /*更新银行卡表*/
        List<CompanyBankReqVo> companyBankReqVoList = res.getBankList();
        if (null != companyBankReqVoList && !companyBankReqVoList.isEmpty()) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            CompanyBankReqVo companyBankReqVo = companyBankReqVoList.get(0);
            ObjectHelper.writeWithFrom(companyBankCardVo, companyBankReqVo);
            companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
            companyBankCardDao.update(companyBankCardVo);
        }

        /*更新商户表*/
        MerchantCreateReqVo merchantCreateReqVo = new MerchantCreateReqVo();

        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        ObjectHelper.writeWithFrom(companyScenicInfoReqVo, companyVo);
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setReqId(reqVo.getReqId());
        companyScenicInfoReqVo.setProductOrInterface(companyVo.getProductOrInterface());
        ResponseResult result1 = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
        if (null == result1 || !"00".equals(result1.getCode())) {
            throw new CodeException("验证失败，请重试");
        }
        Merchant merchant = (Merchant) result1.getData();
        ObjectHelper.writeWithFrom(merchantCreateReqVo, merchant);
        merchantCreateReqVo.setReqId(reqVo.getReqId());
        merchantCreateReqVo.setType(reqVo.getCompanyAttribute());
        merchantCreateReqVo.setName(reqVo.getMerchantName());
        merchantCreateReqVo.setAddress(reqVo.getMerchantAddress());

        resVo.setMerchantId(merchant.getId());

        ResponseResult result2 = storeFeign.merchantCreate(merchantCreateReqVo);
        if (null == result2 || !"00".equals(result2.getCode())) {
            throw new CodeException("验证失败，请重试");
        }

        /*更新用户表*/
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setId(reqVo.getUserId());
        UserVo userVo = userDaoImpl.load(userGetReqVo, UserVo.class);
        userVo.setAccount(reqVo.getAccount());
        userVo.setName(reqVo.getContactName());
        userVo.setPhone(reqVo.getContactPhone());
        userServiceImpl.checkPhone(userVo);
        userDaoImpl.update(userVo);

        resVo.setUserId(userVo.getId());
        return resVo;
    }

    /**
     * 修改公司审核状态
     *
     * @param reqVo 封装了公司id 的请求对象
     * @return
     */
    @Override
    public void updateExamine(UpdateExamineReqVo reqVo) {

        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDao.load(getReqVo, CompanyVo.class);
        companyVo.setExamineStatus(reqVo.getExamineStatus());
        companyVo.setUpdateTime(DateHelper.getNow());
        companyDao.update(companyVo);
    }

    /**
     * 保存/更新银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveBank(CompanyBankCardVo reqVo) {
        String id = StringHelper.getNewID();

        /*若该卡存在，则修改*/
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        if (null != reqVo.getId() && !"".equals(reqVo.getId())) {
            /*检查银行卡号是否存在*/
            CompanyBankCardVo checkReqVo = new CompanyBankCardVo();
            checkReqVo.setId(reqVo.getId());
            checkReqVo.setBankCardCode(reqVo.getBankCardCode());
            companyBankCardDao.checkBankCardCode(checkReqVo);

            getReqVo.setId(reqVo.getId());
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);
            if (null != companyBankCardVo) {
                reqVo.setStatus(companyBankCardVo.getStatus());
                reqVo.setBindingCode(companyBankCardVo.getBindingCode());
                reqVo.setBindingTime(companyBankCardVo.getBindingTime());
                reqVo.setIsDefault(companyBankCardVo.getIsDefault());
                companyBankCardDao.update(companyBankCardVo);
            }
        }
        /*若卡不存在，则新增*/
        else {
            /*检查银行卡号是否存在*/
            CompanyBankCardVo checkReqVo = new CompanyBankCardVo();
            checkReqVo.setBankCardCode(reqVo.getBankCardCode());
            companyBankCardDao.checkBankCardCode(checkReqVo);

            reqVo.setId(id);
            BankCardListReqVo reqVo1 = new BankCardListReqVo();
            PageSizeData<CompanyBankCardVo> companyBankCardDaoBankCardList = companyBankCardDao.getBankCardList(reqVo1);

            /*若该银行卡是第一张银行卡，则设为默认*/
            if (null == companyBankCardDaoBankCardList || companyBankCardDaoBankCardList.getList().isEmpty()) {
                reqVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
            } else {
                reqVo.setIsDefault(CompanyBankCardConstant.IS_NOT_DEFAULT);
            }
            reqVo.setStatus(0);
            companyBankCardDao.create(reqVo);
        }

        /*此处需要调用第三方接口发送手机验证码，并修改数据库状态*/
        CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
        ObjectHelper.writeWithFrom(companyBankReqVo,reqVo);
        ResponseResult result = payFeign.bindBack(companyBankReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("绑定银行卡失败，请重试");
        }
        CompanyBankReqVo resVo = (CompanyBankReqVo) result.getData();
        CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo,resVo);
        companyBankCardVo.setIsDefault(reqVo.getIsDefault());
        companyBankCardDao.update(companyBankCardVo);
        return reqVo.getId();
    }

    /**
     * 调用支付服务解绑银行卡，并更新银行卡状态
     *
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBank(CompanyBankCardVo reqVo) {
        CompanyBankCardVo bankCardVo = companyBankCardDao.load(reqVo, CompanyBankCardVo.class);
        CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
        ObjectHelper.writeWithFrom(companyBankReqVo, bankCardVo);
        ResponseResult result = payFeign.unbindBankCard(companyBankReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("解绑失败，请重试");
        }
        /*若删除的银行卡为默认银行卡，则需要设置其他一张卡为默认银行卡*/
        if (CompanyBankCardConstant.IS_DEFAULT.equals(bankCardVo.getIsDefault())) {
            CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
            getReqVo.setCompanyId(bankCardVo.getCompanyId());
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);
            if (null != companyBankCardVo) {
                companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
                companyExtendDaoImpl.update(companyBankCardVo);
            }
        }
        companyBankCardDao.remove(bankCardVo);
    }

    /**
     * 设置该银行卡为默认支付，并取消其他银行卡的默认
     *
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void setDefault(CompanyBankCardVo reqVo) {
        /*获取该银行卡的公司id*/
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(reqVo, CompanyBankCardVo.class);
        String companyId = companyBankCardVo.getCompanyId();
        /*现将该公司其他银行卡设为非默认*/
        CompanyBankCardSetNotDefaultReqVo setNotDefaultReqVo = new CompanyBankCardSetNotDefaultReqVo();
        setNotDefaultReqVo.setCompanyId(companyId);
        companyBankCardDao.setNotDefault(setNotDefaultReqVo);
        /*将该卡设置为默认银行卡并更新*/
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        companyBankCardDao.update(companyBankCardVo);
    }

    /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     *
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyBankCardVo bankSubmit(BankSubmitReqVo reqVo) {
        /*根据银行卡id获取银行卡信息*/
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);

        /*此处应该将companyBankCardVo和verifyCode发送到第三方接口，获取到的返回值用于更新银行卡状态*/
        CompanyBankReqVo companyBankReqVo = new CompanyBankReqVo();
        ObjectHelper.writeWithFrom(companyBankReqVo,companyBankCardVo);
        companyBankReqVo.setValidateCode(reqVo.getVerifyCode());
        ResponseResult result = payFeign.bindBack(companyBankReqVo);
        if (null == result || !"00".equals(result.getCode())){
            throw new CodeException("绑定银行卡失败，请重试");
        }
        CompanyBankReqVo resVo = (CompanyBankReqVo) result.getData();
        CompanyBankCardVo companyBankCardVo1 = new CompanyBankCardVo();
        ObjectHelper.writeWithFrom(companyBankCardVo1,resVo);
        companyBankCardVo1.setIsDefault(companyBankCardVo.getIsDefault());
        companyBankCardDao.update(companyBankCardVo1);

        return companyBankCardVo1;
    }

    /**
     * y
     * 我的二维码页面
     *
     * @param reqVo 公司扩展表请求对象
     * @return 公司主表信息
     */
    @Override
    public CompanyVo myQrCodeUrl(CompanyGetReqVo reqVo) {
        CompanyVo companyVo = companyDao.load(reqVo, CompanyVo.class);
        if (null == companyVo) {
            throw new CodeException("暂无公司信息");
        }
        return companyVo;
    }

    /**
     * 获取二维码url，有则直接返回，没有则调用微信服务生成url
     *
     * @param reqVo 封装了公司id，页面选项的请求对象
     * @return 二维码url
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String generateQrCodeUrl(GenerateQrCodeUrlReqVo reqVo) {
        CompanyExtendGetReqVo reqVo1 = new CompanyExtendGetReqVo();
        reqVo1.setId(reqVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo1, CompanyExtendVo.class);
        if (null == companyExtendVo) {
            companyExtendVo = new CompanyExtendVo();
            companyExtendVo.setId(reqVo.getCompanyId());
            companyExtendDaoImpl.save(companyExtendVo);
        }
        String url = companyExtendVo.getQrCodeUrl();
        if (null != url && !url.isEmpty() && reqVo.getSelect() == 1) {
            return url;
        }
        String qrCode = companyExtendVo.getQrCode();
        if (null == qrCode || qrCode.isEmpty()) {
            String code = DateHelper.getNow()
                    .replace("-", "")
                    .replace(":", "")
                    .replace(" ", "");
            companyExtendVo.setQrCode(code);
        }
        int select = reqVo.getSelect();
        /*此处应调用微信接口传入qrCode和select获取qrCodeUrl*/
        QrCodeReqVo qrCodeReqVo = new QrCodeReqVo();
        qrCodeReqVo.setReqId(reqVo.getReqId());
        /*临时二维码，超时时间30分钟*/
        SceneInfo sceneInfo = new SceneInfo();
        Scene scene = new Scene();
        scene.setScene_str(companyExtendVo.getQrCode());
        sceneInfo.setScene(scene);
        qrCodeReqVo.setAction_info(sceneInfo);
        if (select == 0) {
            qrCodeReqVo.setExpire_seconds(60 * 30);
            qrCodeReqVo.setAction_name("QR_STR_SCENE");
        } else {
            qrCodeReqVo.setAction_name("QR_LIMIT_STR_SCENE");
        }
        ResponseResult result;
        try {

            result = wxFeign.qcCodeGet(qrCodeReqVo);
        } catch (CodeException e) {
            throw new CodeException(e.getCode(), e.getMessage());
        }

        WxVo wxVo = (WxVo) result.getData();
        String qrCodeUrl = "http://192.168.0.120:8888/" + wxVo.getPdUrl();
        if ("QR_LIMIT_STR_SCENE".equals(qrCodeReqVo.getAction_name())) {
            companyExtendVo.setQrCodeUrl(qrCodeUrl);
            companyExtendDaoImpl.update(companyExtendVo);
        }
        return qrCodeUrl;
    }

    /**
     * 获取银行卡列表
     *
     * @param reqVo 继承了分页对象，含公司id
     * @return 银行卡列表分页对象
     */
    @Override
    public PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo) {

        PageSizeData<CompanyBankCardVo> companyBankCardVoPageSizeData = companyBankCardDao.getBankCardList(reqVo);
        if (companyBankCardVoPageSizeData == null || companyBankCardVoPageSizeData.getList().isEmpty()) {
            throw new CodeException("暂无银行卡，请先添加");
        }
        return companyBankCardVoPageSizeData;
    }

    /**
     * 添加用户
     *
     * @param reqVo 封装了用户信息和用户角色信息的请求对象
     * @return 用户id
     */
    @Override
    public String saveUser(WebUserReqVo reqVo) throws Exception {
        return userServiceImpl.saveUser(reqVo);
    }

    /**
     * 根据请求的数据返回对应的供应商或是接口商列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<CompanyVo> productOrInterface(ProductOrInterfaceReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        ObjectHelper.writeWithFrom(getReqVo, reqVo);
        List<CompanyVo> companyVoList = companyDao.loadList(getReqVo, CompanyVo.class);
        if (null == companyVoList || companyVoList.isEmpty()) {
            throw new CodeException("未找到公司信息");
        }
        return companyVoList;
    }

    /**
     * 批量删除用户
     *
     * @param reqVo 封装了用户id列表的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchDelete(BatchDeleteReqVo reqVo) {
        List<String> userIdList = reqVo.getUserIdList();
        if (null == userIdList || userIdList.isEmpty()) {
            throw new CodeException("删除列表为空，请添加");
        }
        for (String userId : userIdList) {
            UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
            userRoleGetReqVo.setUserId(userId);
            List<UserRoleVo> userRoleVoList = userRoleDaoImpl.loadList(userRoleGetReqVo,UserRoleVo.class);
            if (null != userRoleVoList && userRoleVoList.size() == 1){
                UserRoleGetReqVo userRoleGetReqVo1 = new UserRoleGetReqVo();
                userRoleGetReqVo1.setUserId(userId);
                userRoleGetReqVo1.setRoleId(reqVo.getRoleId());
                UserRoleVo userRoleVo = userRoleDaoImpl.load(userRoleGetReqVo1,UserRoleVo.class);
                userRoleDaoImpl.remove(userRoleVo);
                UserGetReqVo userGetReqVo = new UserGetReqVo();
                userGetReqVo.setId(userId);
                UserVo userVo = userDaoImpl.load(userGetReqVo,UserVo.class);
                userVo.setStatus(1);
                userDaoImpl.update(userVo);
            }else if (null != userRoleVoList && userRoleVoList.size() > 1){
                UserRoleGetReqVo userRoleGetReqVo1 = new UserRoleGetReqVo();
                userRoleGetReqVo1.setUserId(userId);
                userRoleGetReqVo1.setRoleId(reqVo.getRoleId());
                UserRoleVo userRoleVo = userRoleDaoImpl.load(userRoleGetReqVo1,UserRoleVo.class);
                userRoleDaoImpl.remove(userRoleVo);
            }
        }
    }

    /**
     * 批量更新用户信息
     *
     * @param reqVo 封装了用户列表的请求对象
     * @return
     */
    @Override
    public void batchUpdate(BatchUpdateReqVo reqVo) throws Exception {
        List<UserVo> userVoList = reqVo.getUserVoList();
        if (null == userVoList || userVoList.isEmpty()) {
            throw new CodeException("更新列表为空，请添加");
        }
        for (UserVo userVo : userVoList) {
            UserGetReqVo getReqVo = new UserGetReqVo();
            getReqVo.setId(userVo.getId());
            UserVo userVoOld = userDaoImpl.load(getReqVo, UserVo.class);
            if (!StringHelper.compare(userVo.getAccount(), userVoOld.getAccount())) {
                userServiceImpl.isValid(userVo.getAccount());
                userServiceImpl.checkAccount(userVo);
            }
            if ("".equals(userVo.getPassword())) {
                userVo.setPassword(userVoOld.getPassword());
                userVo.setRemark(userVoOld.getRemark());
            } else {
                String password = RSAUtils.decryptionByPrivateKey(userVo.getPassword(), RsaConstant.privateKey);
                userVo.setPassword(StringHelper.md5(password));
                userVo.setRemark(password);
            }
            if (!StringHelper.compare(userVo.getEmail(), userVoOld.getEmail())) {
                userServiceImpl.checkEmail(userVo.getEmail());
            }
            if (!StringHelper.compare(userVo.getPhone(), userVoOld.getPhone())) {
                userServiceImpl.checkPhone(userVo);
            }
            userDaoImpl.update(userVo);
        }
    }

    /**
     * 通过公司id查询该公司邀请的公司
     *
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public PageSizeData<CompanyVo> myInvite(ListCompanyReqVo reqVo) {
        return companyDao.getCompanyList(reqVo);
    }

    @Override
    public String invitation(InvitationReqVo reqVo) {
        return pangdingPartnerServiceImpl.invitation(reqVo);
    }

    /**
     * 根据二维码源码获取公司数据
     *
     * @param reqVo 封装了二维码源码的请求对象
     * @return
     */
    @Override
    public GetCompanyResVo getCompanyByQrCode(GetCompanyByQrCodeReqVo reqVo) {
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setQrCode(reqVo.getQrCode());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendGetReqVo, CompanyExtendVo.class);
        if (null == companyExtendVo) {
            throw new CodeException("未查询到对应公司数据");
        }
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(companyExtendVo.getId());
        GetCompanyResVo companyVo = companyDao.load(companyGetReqVo, GetCompanyResVo.class);
        if (null == companyVo) {
            throw new CodeException("未查询到对应公司数据");
        }
        CompanyMsgReqVo companyMsgReqVo = new CompanyMsgReqVo();
        companyMsgReqVo.setCompanyId(companyVo.getId());
        companyMsgReqVo.setType(companyVo.getCompanyAttribute());
        List<GetCompanyMsgResVo> companyMsgVoList = companyMsgDao.findCompanyMsgList(companyMsgReqVo);
        companyVo.setMsgList(companyMsgVoList);
        return companyVo;
    }

    @Override
    public List<GetCompanyDivideResVo> findCompanyDivideInfo(CompanyDivideReqVo req){
        List<GetCompanyDivideResVo> companyDivideResVoList = new ArrayList<>();
        List<GetCompanyReqVo> companyList = req.getCompanyIdList();
        for (int i = 0; i < companyList.size(); i++){
            GetCompanyReqVo getCompanyReqVo = companyList.get(i);
            GetCompanyDivideResVo companyDivideResVo = companyDivideRuleDao.findCompanyDivideInfo(getCompanyReqVo);
            companyDivideResVo.setCompanyChannelType(getCompanyReqVo.getCompanyChannelType());
            companyDivideResVoList.add(companyDivideResVo);
        }
        return companyDivideResVoList;
    }

    /**
     * 检查邀请码是否真实存在
     * @param reqVo
     * @return
     */
    @Override
    public CompanyVo checkInvitationCode(CheckInvitationCodeReqVo reqVo) {
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setInvitationCode(reqVo.getInvitationCode());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendGetReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo){
            throw new CodeException("该邀请码为错误邀请码");
        }
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(companyExtendVo.getId());
        return companyDao.load(companyGetReqVo,CompanyVo.class);
    }

    /**
     * 审核公司
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void examineConfig(ExamineConfigReqVo reqVo) {
        /*更新公司表*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDao.load(companyGetReqVo,CompanyVo.class);
        companyVo.setExamineStatus(reqVo.getExamineStatus());
        companyVo.setExamineFailedReason(reqVo.getExamineFailedReason());
        companyDao.update(companyVo);
        /*更新公司扩展表*/
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(reqVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendGetReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo){
            companyExtendVo = new CompanyExtendVo();
            companyExtendVo.setId(reqVo.getCompanyId());
            companyExtendVo.setQrCode(DateHelper.getNow()
                    .replace("-", "")
                    .replace(":", "")
                    .replace(" ", ""));
            companyExtendVo.setWithdrawMoney(reqVo.getWithdrawMoney());
            companyExtendVo.setWithdrawRule(reqVo.getWithdrawRule());
            companyExtendVo.setWithdrawFee(reqVo.getWithdrawFee());
            companyExtendVo.setQrCodeType(reqVo.getQrCodeType());
            companyExtendDaoImpl.create(companyExtendVo);
        }else {
            companyExtendVo.setWithdrawMoney(reqVo.getWithdrawMoney());
            companyExtendVo.setWithdrawRule(reqVo.getWithdrawRule());
            companyExtendVo.setWithdrawFee(reqVo.getWithdrawFee());
            companyExtendVo.setQrCodeType(reqVo.getQrCodeType());
            companyExtendDaoImpl.update(companyExtendVo);
        }
        /*新增或更新pd_company_divide_rule表*/
        CompanyDivideRuleVo companyDivideRuleVo = new CompanyDivideRuleVo();
        ObjectHelper.writeWithFrom(companyDivideRuleVo,reqVo);
        CompanyDivideRuleGetReqVo companyDivideRuleGetReqVo = new CompanyDivideRuleGetReqVo();
        companyDivideRuleGetReqVo.setCompanyId(reqVo.getCompanyId());
        CompanyDivideRuleVo companyDivideRuleResVo = companyDivideRuleDao.load(companyDivideRuleGetReqVo,CompanyDivideRuleVo.class);
        if (null == companyDivideRuleResVo){
            companyDivideRuleVo.setCompanyDivideId(StringHelper.getNewID());
            companyDivideRuleDao.create(companyDivideRuleVo);
        }else {
            companyDivideRuleVo.setCompanyDivideId(companyDivideRuleResVo.getCompanyDivideId());
            companyDivideRuleVo.setFee(companyDivideRuleResVo.getFee());
            companyDivideRuleVo.setBonusType(companyDivideRuleResVo.getBonusType());
            companyDivideRuleVo.setBonusValue(companyDivideRuleResVo.getBonusValue());
            companyDivideRuleVo.setRealBonusValue(companyDivideRuleResVo.getRealBonusValue());
            companyDivideRuleVo.setBonusExplain(companyDivideRuleResVo.getBonusExplain());
            companyDivideRuleDao.update(companyDivideRuleVo);
        }
        /*更新角色表*/
        RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
        roleGetReqVo.setId(reqVo.getRoleId());
        RoleVo roleVo = roleDaoImpl.load(roleGetReqVo,RoleVo.class);
        roleVo.setCompanyId(reqVo.getCompanyId());
        roleVo.setIsAdmin(1);
        roleDaoImpl.update(roleVo);
        /*保存用户角色关系*/
        UserRoleVo userRoleVo = new UserRoleVo();
        userRoleVo.setId(StringHelper.getNewID());
        userRoleVo.setUserId(reqVo.getUserId());
        userRoleVo.setRoleId(roleVo.getId());
        userRoleDaoImpl.create(userRoleVo);
    }



    @Override
    public ResponseResult<String> updateCompanyMoney(UpdateCompanyMoneyReqVo req){
        CompanyVo companyVo = companyDao.load(req.getCompanyId(), CompanyVo.class);
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(req.getCompanyId(), CompanyExtendVo.class);
        if(StringHelper.isEmpty(companyVo) && StringHelper.isEmpty(companyExtendVo)){
           throw new CodeException("未找到公司信息");
        }
        try{
            // 可提现余额
            double companyMoney = companyExtendVo.getWithdrawTotalCash();
//            req = new UpdateCompanyMoneyReqVo();
//            req.setCompanyId(companyVo.getId());

            if(CompanyConstant.MONEY_TYPE_FZ == req.getMoneyType()
                    || CompanyConstant.MONEY_TYPE_ZZ == req.getMoneyType()
                    || CompanyConstant.MONEY_TYPE_CZ == req.getMoneyType() ){
                // 分账 转账 充值
                companyMoney += req.getMoney();
            }
            if(CompanyConstant.MONEY_TYPE_REFUND == req.getMoneyType()
                    || CompanyConstant.MONEY_TYPE_TX == req.getMoneyType()){
                // 退款 提现
                companyMoney -= req.getMoney();
            }
//            int orderMoneyType = 0;
//            int divideMoneyType = 0;
//            List<CompanyMoneyDateilVo> companyMoneyDateilVoList = companyMoneyDetailDao.loadList(req, CompanyMoneyDateilVo.class);
//            for(int i = 0; i < companyMoneyDateilVoList.size(); i++){
//                CompanyMoneyDateilVo companyMoneyDateilVo = companyMoneyDateilVoList.get(i);
//                if(CompanyConstant.MONEY_TYPE_ORDER == companyMoneyDateilVo.getMoneyType()){
//                    orderMoneyType = 1;
//                    if(CompanyConstant.MONEY_TYPE_REFUND == req.getMoneyType()){
//                        companyMoneyDateilVo.setMoney(companyMoneyDateilVo.getMoney() - money);
//                        companyMoneyDetailDao.update(companyMoneyDateilVo);
//                    }else{
//                        companyMoneyDateilVo.setMoney(companyMoneyDateilVo.getMoney() + addMoney);
//                        companyMoneyDetailDao.update(companyMoneyDateilVo);
//                    }
//                }
//                if(CompanyConstant.MONEY_TYPE_DIVIDE == companyMoneyDateilVo.getMoneyType()){
//                    divideMoneyType = 1;
//                    if(CompanyConstant.MONEY_TYPE_ZZ == req.getMoneyType()){
//                        companyMoneyDateilVo.setMoney(companyMoneyDateilVo.getMoney() + addMoney);
//                        companyMoneyDetailDao.update(companyMoneyDateilVo);
//                    }
//                }
//            }

            companyExtendVo.setWithdrawTotalCash(companyMoney);
            companyExtendDaoImpl.update(companyExtendVo);
            return ResponseResult.result("处理完成");
        }catch (CodeException e){
             throw new CodeException("");
        }
    }

}
