package com.pangding.web.tright.service;

import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.vo.RoleVo;

import java.util.List;

public interface RoleService {

    void saveRole(RoleVo roleVo);

    RoleVo getRoleById(String id);

    RoleVo getRoleByName(String name);

    void roleAndTright(RoleDto roleDto);

    Boolean checkNameExist(RoleVo roleVo);

    List<RoleVo> getRoleVoList();

    List<String> getTrightIdList(String roleId);

    String getTrightNameByTrightId(String trightId);

    RoleDto makeRoleDto(RoleVo roleVo,List<String> trightIdList,List<String> trightNameList);

    void deleteRole(String roleId);

    void deleteRoleUser(String roleId);

    void deleteRoleTright(String roleId);

    String getRoleUserPKByRoleId(String roleId);

    String getRoleTrightPKByRoleId(String roleId);
}
