package com.pangding.web.tright.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

@TableAnnotation("pd_user")
public class UserVo implements Serializable, InitDao {

    /*主键id*/
    private String id;
    /*账号*/
    private String account;
    /*密码*/
    private String password;
    /*手机号*/
    private String phone;
    /*状态*/
    private String status;
    /*描述*/
    private String remark;
    @TableAnnotation("create_time")
    /*创建时间*/
    private Timestamp createTime;
    /*创建人*/
    private String creator;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Timestamp getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public void init() {
        String createTimeString = StringHelper.getFirst(DateHelper.getDateTimeString(this.createTime), DateHelper.getNow());
        this.createTime = Timestamp.valueOf(createTimeString);
    }
}
