package com.pangding.web.authority.controller;


import com.pangding.web.authority.vo.reqvo.AddReqVo;
import com.pangding.web.authority.vo.reqvo.CountByRoleReqVo;
import com.pangding.web.authority.vo.reqvo.ListRoleReqVo;
import com.pangding.web.authority.vo.reqvo.WebRoleReqVo;
import com.pangding.web.authority.service.RoleService;
import com.pangding.web.authority.vo.resvo.WebRoleResVo;
import com.pangding.web.vo.system.res.authority.RoleResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/roles")
public class RoleController {

    @Autowired
    private RoleService roleService;


    @RequestMapping(value = "/queryList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<RoleResVo>> queryList(@RequestBody ListRoleReqVo req){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",req.getCompanyId())
                .checkException();
        return ResponseResult.result(roleService.queryList(req));
    }


    /**
     * 新增角色
     * 返回角色id
     * @param webRoleReqVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveRole(@RequestBody WebRoleReqVo webRoleReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("roleName",webRoleReqVo.getName())
                .notBlankCheck("remark",webRoleReqVo.getRemark())
                .notBlankCheck("companyId",webRoleReqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(roleService.saveRole(webRoleReqVo));
    }

    /**
     * 修改角色信息
     * 返回角色id
     * @param webRoleReqVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> updateRole(@RequestBody WebRoleReqVo webRoleReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("roleName",webRoleReqVo.getName())
                .notBlankCheck("remark",webRoleReqVo.getRemark())
                .checkException();
        return ResponseResult.result(roleService.updateRole(webRoleReqVo));
    }

    /**
     * 查询角色列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebRoleResVo>> listRoles(@RequestBody ListRoleReqVo req){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",req.getCompanyId())
                .checkException();
        return ResponseResult.result(roleService.getWebRoleResVoList(req));
    }

    /**
     * 获取该公司该角色已分配的角色列表
     * @param reqVo 封装了公司id和权限id的请求对象
     * @return 用户列表
     */
    @RequestMapping(value = "/countByRole", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult countByRole(@RequestBody CountByRoleReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("roleId",reqVo.getRoleId())
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(roleService.countByRole(reqVo));
    }

    /**
     * 根据ID查询角色
     * @param
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<WebRoleResVo> getRoleById(@RequestBody WebRoleReqVo webRoleReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("roleId",webRoleReqVo.getId())
                .checkException();
        return ResponseResult.result(roleService.getRoleById(webRoleReqVo));
    }

    /**
     * 删除角色
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult delete(@RequestBody WebRoleReqVo webRoleReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("roleId",webRoleReqVo.getId())
                .checkException();
        roleService.delete(webRoleReqVo);
        return new ResponseResult();
    }

    /**
     * 给指定角色添加权限
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/add",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult add(@RequestBody AddReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("roleId",reqVo.getRoleId())
                .notBlankCheck("authorityId",reqVo.getAuthorityId())
                .checkException();
        roleService.add(reqVo);
        return new ResponseResult();
    }
}
