package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyCodeDao;
import com.pangding.web.vo.system.pd.company.CompanyCodeVo;
import com.pangding.web.vo.system.req.company.CompanyCodeReqVo;
import com.pangding.web.vo.system.res.company.CompanyCodeResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyCodeDaoImpl extends BaseDaoImpl implements CompanyCodeDao {

    private final String FIND_CODE_LIST = "FIND_CODE_LIST";


    @Override
    protected void init() {
        register(CompanyCodeVo.class);

        table.add(FIND_CODE_LIST, "select a.*,b.enum_value as enumName " +
                "from pd_company_code a left join pd_enum b on a.code_type = b.enum_key " +
                "where b.child_type = 'code_type'")
                .add("companyId","AND company_id = ? ");

    }

    public List<CompanyCodeResVo> findCodeList(CompanyCodeReqVo req){
        return query(CompanyCodeResVo.class, FIND_CODE_LIST, req);
    }


}
