package com.pangding.web.tright.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.pangding.web.tright.currency.Result;
import com.pangding.web.tright.dao.TrightDao;
import com.pangding.web.tright.service.TrightService;
import com.pangding.web.tright.vo.TrightVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/tright")
public class TrightController {

    @Autowired
    TrightService trightServiceImpl;
    @Autowired
    TrightDao trightDao;

    /**
     * 新增权限
     * @param trightVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object saveTright(@RequestBody TrightVo trightVo){
        trightServiceImpl.save(trightVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 修改权限信息
     * @param trightVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object updateTright(@RequestBody TrightVo trightVo){
        trightServiceImpl.update(trightVo);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }

    /**
     * 查询权限列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object listTrights(){
        List<TrightVo> trightVos = trightDao.listAll();
        List<TrightVo> list = Lists.newArrayList();
        setPermissionsList(0L,trightVos, list);
        Result result = new Result(0,"SUCCESS",list);
        return result;
    }


    /**
     * 菜单列表
     *
     * @param pId
     * @param trightVos
     * @param list
     */
    private void setPermissionsList(Long pId, List<TrightVo> trightVos, List<TrightVo> list) {
        for (TrightVo per : trightVos) {
            if (per.getModuleId().equals(pId)) {
                list.add(per);
                if (trightVos.stream().filter(p -> p.getModuleId().equals(per.getTrId())).findAny() != null) {
                    setPermissionsList(per.getTrId(), trightVos, list);
                }
            }
        }
    }
    /**
     * 查询一级权限
     * @return
     */
    @RequestMapping(value = "/parent", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object parentTrights(){
        List<TrightVo> parentTrights = trightDao.listParents();
        Result result = new Result(0,"SUCCESS",parentTrights);
        return result;
    }

    /**
     * 查询所有权限
     * @return
     */
    @RequestMapping(value = "/all", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object allTrights(){
        List<TrightVo> trightVos = trightDao.listAll();
        JSONArray array = new JSONArray();
        setPermissionsTree(0L,trightVos, array);
        Result result = new Result(0,"SUCCESS",array);
        return result;
    }

    /**
     * 菜单树
     *
     * @param pId
     * @param trightVos
     * @param array
     */
    private void setPermissionsTree(Long pId, List<TrightVo> trightVos, JSONArray array) {
        for (TrightVo per : trightVos) {
            if (per.getModuleId().equals(pId)) {
                String string = JSONObject.toJSONString(per);
                JSONObject parent = (JSONObject) JSONObject.parse(string);
                array.add(parent);

                if (trightVos.stream().filter(p -> p.getModuleId().equals(per.getTrId())).findAny() != null) {
                    JSONArray child = new JSONArray();
                    parent.put("child", child);
                    setPermissionsTree(per.getTrId(), trightVos, child);
                }
            }
        }
    }

    /**
     * 根据ID查询权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object tright(@PathVariable Long id){
        trightDao.getById(id);
        Result result = new Result(0,"SUCCESS",null);
        return null;
    }

    /**
     * 删除权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object delete(@PathVariable Long id){
        trightServiceImpl.delete(id);
        Result result = new Result(0,"SUCCESS",null);
        return result;
    }
}
