package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.service.UserService;
import com.pangding.web.tright.vo.UserRoleRelation;
import com.pangding.web.tright.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;

    @Override
    public UserVo saveUser(UserDto userDto) {
        UserVo userVo = userDto;
        userDao.create(userVo);
        userAndRole(userDto);
        return userVo;
    }

    private void saveUserRoles(List<UserRoleRelation> userRoleRelations) {
            userDao.deleteUserRole(userRoleRelations.get(0));
            if (!CollectionUtils.isEmpty(userRoleRelations)) {
                userDao.saveUserRoles(userRoleRelations);
            }
    }

    @Override
    public UserVo updateUser(UserDto userDto) {
        userDao.update(userDto);
        userAndRole(userDto);
        return userDto;
    }

    @Override
    public UserVo getUser(UserVo userVo) {
        return userDao.getUser(userVo);
    }

    @Override
    public String passwordEncoder(String credentials, String salt) {
        return null;
    }

    private void userAndRole(UserDto userDto){
        if (userDto.getRoleIds()!=null&&userDto.getRoleIds().size()!=0) {
            List<Long> longs = userDto.getRoleIds();//多个角色
            List<UserRoleRelation> userRoleRelations = new ArrayList<>();
            //查询当前用户的ID
            //UserVo userVo = userDao.getUser(userDto);
            for (Long l : longs) {
                UserRoleRelation userRoleRelation = new UserRoleRelation();
                userRoleRelation.setTr_id(l);
                userRoleRelation.setTu_id(userDto.getTuId());
                userRoleRelations.add(userRoleRelation);
            }
            saveUserRoles(userRoleRelations);
        }
    }
}
