package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.reqvo.GetUserRoleListByRoleIdReqVo;
import com.pangding.web.authority.reqvo.GetUserRoleListByUserIdReqVo;
import com.pangding.web.authority.vo.UserRoleRelation;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserRoleDaoImpl extends BaseDaoImpl implements UserRoleDao {

    private static final String GET_USER_ROLE_LIST = "GET_USER_ROLE_LIST";

    @Override
    protected void init() {

        register(UserRoleRelation.class);

        table.add(GET_USER_ROLE_LIST,"select * from pd_user_role where 1=1 ")
                .add("userId","and user_id = ?")
                .add("roleId","and role_id = ?");

    }

    @Override
    public List<UserRoleRelation> getUserRoleListByUserId(GetUserRoleListByUserIdReqVo userId) {
        return this.query(UserRoleRelation.class,GET_USER_ROLE_LIST,userId);
    }

    @Override
    public List<UserRoleRelation> getUserRoleListByRoleId(GetUserRoleListByRoleIdReqVo roleId) {
        return this.query(UserRoleRelation.class,GET_USER_ROLE_LIST,roleId);
    }
}
