package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.MobileRegisterDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.dto.RegisterIndividualDto;
import com.pangding.web.authority.reqvo.CheckMerchantIdReqVo;
import com.pangding.web.authority.reqvo.GetUserByCompanyIdReqVo;
import com.pangding.web.authority.service.MobileRegisterService;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:23
 */

@Service
public class MobileRegisterServiceImpl implements MobileRegisterService {

    @Autowired
    MobileRegisterDao mobileRegisterDaoImpl;
    @Autowired
    UserDao userDaoImpl;

    @Override
    public Boolean checkMerchantId(String merchantId) {
        CheckMerchantIdReqVo idReqVo = new CheckMerchantIdReqVo();
        idReqVo.setId(merchantId);
        CompanyVo companyVo = mobileRegisterDaoImpl.load(idReqVo,CompanyVo.class);
        return companyVo == null ? false : true;
    }

    @Override
    public void saveUser(UserVo userVo) {
        userDaoImpl.create(userVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveCompany(CompanyVo companyVo) {
        mobileRegisterDaoImpl.create(companyVo);
        GetUserByCompanyIdReqVo companyId = new GetUserByCompanyIdReqVo();
        companyId.setCompanyId(companyVo.getId());
        UserVo userVo = userDaoImpl.getUserByCompanyId(companyId);
        userVo.setPhone(companyVo.getContactPhone());
        userDaoImpl.update(userVo);
    }

    @Override
    public void checkPhone(String contactPhone) {
        CompanyVo companyVo = new CompanyVo();
        companyVo.setContactPhone(contactPhone);
        mobileRegisterDaoImpl.checkPhone(companyVo);
    }
}
