package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.RoleDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.dto.UserDto;
import com.pangding.web.authority.reqvo.*;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.utils.Md5AndSalt;
import com.pangding.web.authority.vo.*;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;

    @Autowired
    UserRoleDao userRoleDao;

    @Autowired
    RoleDao roleDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveUser(UserDto userDto) {
        UserVo userVo = userDto;
        userDao.create(userVo);
        if (userDto.getRoleIds()!=null&&userDto.getRoleIds().size()!=0){
            List<String> roleIds = userDto.getRoleIds();
            for (String roleId : roleIds) {
                UserRoleRelation userRoleRelation = new UserRoleRelation();
                userRoleRelation.setRoleId(roleId);
                userRoleRelation.setUserId(userDto.getId());
                userRoleRelation.setId(StringHelper.getNewID());
                userRoleDao.create(userRoleRelation);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateUser(UserDto userDto) {
        UserVo userVo = userDto;
        userDao.update(userVo);
        GetUserRoleListByUserIdReqVo userId = new GetUserRoleListByUserIdReqVo();
        userId.setUserId(userDto.getId());
        List<UserRoleRelation> userRoleList = userRoleDao.getUserRoleListByUserId(userId);
        List<String> userRoleIdList = new ArrayList(userRoleList.size());
        for (UserRoleRelation userRole:userRoleList) {
            userRoleIdList.add(userRole.getId());
        }
        if (userRoleIdList != null && userRoleIdList.size() != 0){
            for (String userRoleId:userRoleIdList){
                UserRoleDaoRemoveReqVo userRole = new UserRoleDaoRemoveReqVo();
                userRole.setId(userRoleId);
                userRoleDao.remove(userRole);
            }
        }
        if (userDto.getRoleIds()!=null&&userDto.getRoleIds().size()!=0){
            List<String> roleIds = userDto.getRoleIds();
            for (String roleId : roleIds) {
                UserRoleRelation userRoleRelation = new UserRoleRelation();
                userRoleRelation.setRoleId(roleId);
                userRoleRelation.setUserId(userDto.getId());
                userRoleRelation.setId(StringHelper.getNewID());
                userRoleDao.create(userRoleRelation);
            }
        }
    }

    @Override
    public List<UserVo> listUserVo() {

        return userDao.listUserVo();
    }

    @Override
    public void checkAccount(UserVo userVo) {
        userDao.checkAccount(userVo);
    }

    @Override
    public void checkPhone(UserVo userVo) {
        userDao.checkPhone(userVo);
    }

    @Override
    public String passwordEncoder(String password) { return Md5AndSalt.generate(password); }


    @Override
    public UserDto makeUserDto(UserVo userVo, List<String> roleIdList, List<String> roleNameList) {
        UserDto userDto = new UserDto();
        userDto.setPassword(userVo.getPassword());
        userDto.setAccount(userVo.getAccount());
        userDto.setCreateTime(userVo.getCreateTime());
        userDto.setCreator(userVo.getCreator());
        userDto.setId(userVo.getId());
        userDto.setPhone(userVo.getPhone());
        userDto.setRemark(userVo.getRemark());
        userDto.setStatus(userVo.getStatus());
        userDto.setRoleIds(roleIdList);
        userDto.setRoles(roleNameList);
        return userDto;
    }

    @Override
    public UserVo getUserById(String userId) {
        GetUserByIdReqVo id = new GetUserByIdReqVo();
        id.setId(userId);
        return userDao.getUserById(id);
    }

    @Override
    public List<UserRoleRelation> listUserRoleListByUserId(GetUserRoleListByUserIdReqVo reqVo) {
        return userRoleDao.getUserRoleListByUserId(reqVo);
    }

    @Override
    public RoleVo getRoleByRoleId(GetRoleByRoleIdReqVo getRoleByRoleIdReqVo) {
        return roleDao.getRoleById(getRoleByRoleIdReqVo);
    }

    @Override
    public Boolean isNumeric(String account) {
        for (int i = 0;i < account.length();i++){
            if (!Character.isDigit(account.charAt(i))){
                return false;
            }
        }

        return true;
    }

    @Override
    public Boolean isValid(String account) {
        String regex = "^(?!\\d+$)[\\da-zA-Z]+$";
        return account.matches(regex);
    }

    @Override
    public UserVo getUserByPhone(String phone) {
        GetUserByPhoneReqVo getUserByPhoneReqVo = new GetUserByPhoneReqVo();
        getUserByPhoneReqVo.setPhone(phone);
        return userDao.load(getUserByPhoneReqVo,UserVo.class);
    }

    @Override
    public UserVo getUserByAccount(String account) {
        GetUserByAccountReqVo getUserByAccountReqVo = new GetUserByAccountReqVo();
        getUserByAccountReqVo.setAccount(account);
        return userDao.load(getUserByAccountReqVo, UserVo.class);
    }
}
