package com.tcm.product.dao.impl;

import com.tcm.product.dao.ProductCategoryDao;
import com.tcm.util.product.ProductCategoryVo;
import com.tcm.util.product.req.ProductCategoryLoadPageReqVo;
import com.tcm.util.product.res.ProductCategoryResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class ProductCategoryDaoImpl extends BaseDaoImpl implements ProductCategoryDao {

    private static final String SQL_LOAD_BY_PAGE = "LOAD_BY_PAGE";

    @Override
    protected void init() {
        register(ProductCategoryVo.class);
        table.add(SQL_LOAD_BY_PAGE, "select p.*,pe.category_name as categoryName,pe.introduction as introduction," +
                " pe.product_efficacy as productEfficacy,ti.image_url as imageUrl from tcm_product_category as  p " +
                " left join tcm_product_category_extend as pe on p.category_id = pe.category_id" +
                " left join tcm_image as ti on p.category_id = ti.relation_id  where 1=1 {WHERE} order by p.sort")
                .add("categoryId", "and p.category_id = ?")
                .add("languageType", "and pe.language_type =?")
                .add("categoryType", "and p.category_type = ?")

        ;
    }

    @Override
    public PageSizeData<ProductCategoryResVo> loadByPage(ProductCategoryLoadPageReqVo req) {
        return this.queryPage(ProductCategoryResVo.class, req, SQL_LOAD_BY_PAGE, req);
    }
}
