package com.tcm.system.user.dao.impl;

import com.tcm.system.user.dao.UserDao;
import com.tcm.system.user.vo.TcmUserVo;
import com.tcm.system.user.vo.req.TcmUserPageReqVo;
import com.tcm.system.user.vo.req.TcmUserReqVo;
import com.tcm.system.user.vo.res.TcmUserResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class UserDaoImpl extends BaseDaoImpl implements UserDao {

    private static final String QUERY_USER = "QUERY_USER";

    private static final String QUERY_LIST = "QUERY_LIST";


    @Override
    protected void init() {
        register(TcmUserVo.class);

        table.add(QUERY_USER,"select * from tcm_sys_user where 1=1")
                .add("companyId","and company_id = ? ")
                .add("account","and username = ? ")
                .add("phone","and phone = ? ")
                .add("loginAccount","and (username = ? or phone = ?) ")
                .add("roleId","  role_id = ? ");

        table.add(QUERY_LIST,"select a.*,b.*,c.* from tcm_sys_user a " +
                " LEFT JOIN tcm_sys_role b on  a.role_id = b.role_id " +
                " LEFT JOIN tcm_sys_position c on c.position_id = a.position_id " +
                " where 1=1 ")
                .add("companyId","and company_id = ? ")
                .add("account","and username = ? ")
                .add("phone","and phone = ? ")
                .add("loginAccount","and (username = ? or phone = ?) ")
                .add("roleId","  role_id = ? ");
    }

    @Override
    public TcmUserResVo queryUser(TcmUserReqVo req) {
        return this.queryFirst(TcmUserResVo.class, QUERY_USER, req);
    }

    @Override
    public PageSizeData<TcmUserResVo> findUserPage(TcmUserPageReqVo req) {
        return this.queryPage(TcmUserResVo.class, req, QUERY_LIST, req);
    }

    @Override
    public List<TcmUserResVo> findUserList(TcmUserReqVo req) {
        return this.query(TcmUserResVo.class, QUERY_LIST, req);
    }

    @Override
    public TcmUserResVo findUserInfo(TcmUserReqVo req) {
        return this.queryFirst(TcmUserResVo.class, QUERY_LIST, req);
    }
}
