package com.tcm.util.area;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_floor_extend")
public class FloorExtendVo {

    /**
     * 楼层扩展id
     */
    @TableAnnotation("floor_extend_id")
    @ApiModelProperty(notes = "楼层扩展id")
    private String floorExtendId;
    /**
     * 楼层id
     */
    @TableAnnotation("floor_id")
    @ApiModelProperty(notes = "楼层id")
    private String floorId;
    /**
     * 楼层名称
     */
    @TableAnnotation("floor_name")
    @ApiModelProperty(notes = "楼层名称")
    private String floorName;
    /**
     * 楼层标签
     */
    @TableAnnotation("label")
    @ApiModelProperty(notes = "楼层标签")
    private String label;

    /**
     * 语言类型
     */
    @TableAnnotation("language_type")
    @ApiModelProperty(notes = "语言类型")
    private Integer languageType;
    /**
     * 楼层详情介绍
     */
    @TableAnnotation("floor_desc")
    @ApiModelProperty(notes = "楼层详情介绍")
    private String floorDesc;

    public FloorExtendVo() {
    }

    public String getFloorExtendId() {
        return floorExtendId;
    }

    public void setFloorExtendId(String floorExtendId) {
        this.floorExtendId = floorExtendId;
    }

    public String getFloorId() {
        return floorId;
    }

    public void setFloorId(String floorId) {
        this.floorId = floorId;
    }

    public String getFloorName() {
        return floorName;
    }

    public void setFloorName(String floorName) {
        this.floorName = floorName;
    }

    public Integer getLanguageType() {
        return languageType;
    }

    public void setLanguageType(Integer languageType) {
        this.languageType = languageType;
    }

    public String getFloorDesc() {
        return floorDesc;
    }

    public void setFloorDesc(String floorDesc) {
        this.floorDesc = floorDesc;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}
