package com.pangding.web.authority.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.vo.BaseVo;

import java.math.BigDecimal;

/**
 * @author LBW
 * @name 商家（景区）基本信息
 * @create 2019-04-28 15:21
 */
public class Merchant extends BaseVo {
    /**
     * 主键
     */
    private String id;

    /**
     * 编号
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;

    /**
     * 评分
     */
    private BigDecimal score;

    /**
     * 行政区域编号
     */
    private String areaCode;

    /**
     * 行政区域名称
     */
    private String areaName;

    /**
     * 地址
     */
    private String address;

    /**
     * 类型（1：景区；2：餐饮；3：酒店）
     */
    private String type;

    /**
     * 标签
     */
    private String tag;

    /**
     * 等级
     */
    private String level;

    /**
     * 状态（0：上架；1：下架）
     */
    private String status;

    /**
     * 游玩耗时
     */
    @TableAnnotation("time_spent")
    private String timeSpent;

    /**
     * 电话
     */
    private String phone;

    /**
     * 供应商
     */
    @TableAnnotation("product_company_id")
    private String productCompanyId;

    /**
     * 接口商
     */
    @TableAnnotation("interface_company_id")
    private String interfaceCompanyId;

    /**
     * 营业时间(开始)
     */
    @TableAnnotation("business_start")
    private String businessStart;

    /**
     * 营业时间(结束)
     */
    @TableAnnotation("business_end")
    private String businessEnd;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableAnnotation("create_time")
    private String createTime;

    /**
     * 创建者ID
     */
    @TableAnnotation("user_id")
    private String userId;

    /**
     * 创建者
     */
    private String username;

    /**
     * 来源
     */
    private String source;

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTimeSpent() {
        return timeSpent;
    }

    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getProductCompanyId() {
        return productCompanyId;
    }

    public void setProductCompanyId(String productCompanyId) {
        this.productCompanyId = productCompanyId;
    }

    public String getInterfaceCompanyId() {
        return interfaceCompanyId;
    }

    public void setInterfaceCompanyId(String interfaceCompanyId) {
        this.interfaceCompanyId = interfaceCompanyId;
    }

    public String getBusinessStart() {
        return businessStart;
    }

    public void setBusinessStart(String businessStart) {
        this.businessStart = businessStart;
    }

    public String getBusinessEnd() {
        return businessEnd;
    }

    public void setBusinessEnd(String businessEnd) {
        this.businessEnd = businessEnd;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}
