package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.feign.PayFeign;
import com.pangding.web.authority.feign.StoreFeign;
import com.pangding.web.authority.feign.WxFeign;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.service.PangdingPartnerService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.util.CompanyBankCardConstant;
import com.pangding.web.authority.util.CompanyConstant;
import com.pangding.web.authority.util.RsaConstant;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.*;
import com.pangding.web.constant.OrderConstant;
import com.pangding.web.mq.CompanyProducer;
import com.pangding.web.util.RSAUtils;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.product.pd.merchant.MerchantVo;
import com.pangding.web.vo.system.pd.CompanyMsgVo;
import com.pangding.web.vo.system.pd.authority.RoleVo;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyDivideRuleVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.CompanyMsgReqVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyDetailReqVo;
import com.pangding.web.vo.system.req.company.CompanyMoneyUpdateReqVo;
import com.pangding.web.vo.system.res.CompanyMsgResVo;
import com.pangding.web.vo.system.res.company.CompanyExtendResVo;
import com.pangding.web.vo.system.res.company.CompanyMoneyDetailResVo;
import com.pangding.web.vo.system.res.company.FindCompanyBalanceResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.JsonHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 */
@Service
public class CompanyServiceImpl implements CompanyService {

    @Autowired
    private CompanyDao companyDao;
    @Autowired
    private CompanyExtendDao companyExtendDao;
    @Autowired
    private CompanyBankCardDao companyBankCardDao;
    @Autowired
    private UserService userService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PayFeign payFeign;
    @Autowired
    private StoreFeign storeFeign;
    @Autowired
    private WxFeign wxFeign;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private PangdingPartnerService pangdingPartnerService;
    @Autowired
    private CompanyMsgDao companyMsgDao;
    @Autowired
    private CompanyDivideRuleDao companyDivideRuleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private CompanyMoneyDetailDao companyMoneyDetailDao;
    @Autowired
    private CompanyProducer companyProducer;

    /**
     * 修改公司信息
     *
     * @param companyVo
     */
    @Override
    public void updateCompanyStatus(CompanyVo companyVo) {
        CompanyVo company = companyDao.load(companyVo.getId(), CompanyVo.class);
        ObjectHelper.writeWithFrom(company, companyVo);
        companyDao.update(company);
    }

    /**
     * 分页查询公司信息
     *
     * @param reqVo 继承了分页对象
     * @return 公司列表分页对象
     */
    @Override
    public PageSizeData<CompanyVo> list(ListCompanyReqVo reqVo) {
        PageSizeData<CompanyVo> pageSizeData = companyDao.getCompanyList(reqVo);
        if (null == pageSizeData || null == pageSizeData.getList() || pageSizeData.getList().isEmpty()) {
            throw new CodeException("暂无公司信息");
        }
        return pageSizeData;
    }

    /**
     * 胖丁查询用户，公司和公司扩展表信息以及银行卡列表
     *
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司，公司扩展表和银行卡列表信息的对象
     */
    @Override
    public CompanyResVo pdGetDetail(CompanyGetReqVo reqVo) {
        CompanyResVo resVo = getDetail(reqVo);
        /*获取用户表信息*/
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setIsFirst(1);
        userGetReqVo.setCompanyId(reqVo.getId());
        UserVo userVo = userDao.load(userGetReqVo, UserVo.class);
        if (null != userVo) {
            userVo.setPassword("");
            userVo.setRemark("");
            resVo.setUserVo(userVo);
        } else {
            UserGetReqVo userGetReqVo1 = new UserGetReqVo();
            userGetReqVo1.setCompanyId(reqVo.getId());
            UserVo userVo1 = userDao.load(userGetReqVo1, UserVo.class);
            resVo.setUserVo(userVo1);
        }
        /*获取没有公司id的角色数组*/
        GetEmptyRolesReqVo getEmptyRolesReqVo = new GetEmptyRolesReqVo();
        List<RoleVo> roleVoList = roleDao.getEmptyRoles(getEmptyRolesReqVo);
        /*if (null == roleVoList || roleVoList.isEmpty()){
            throw new CodeException("暂无未分配的角色，请先创建角色");
        }*/
        resVo.setRoleVoList(roleVoList);
        return resVo;
    }

    @Override
    public CompanyResVo getDetail(CompanyGetReqVo reqVo) {
        CompanyResVo resVo = new CompanyResVo();
        /*获取公司表信息*/
        CompanyVo companyVo = companyDao.load(reqVo, CompanyVo.class);
        if (null != companyVo) {
            resVo.setCompanyVo(companyVo);
        }

        /*此处需要根据公司id和productOrInterface获取商户信息*/
        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setProductOrInterface(companyVo.getProductOrInterface());
        companyScenicInfoReqVo.setReqId(reqVo.getReqId());
        try {
            ResponseResult result = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
            if (null != result && "00".equals(result.getCode())) {
                resVo.setMerchant((MerchantVo) result.getData());
            }
        } catch (Exception e) {
            resVo.setMerchant(null);
        }

        /*获取公司扩展表信息*/
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(reqVo.getId());
        CompanyExtendVo companyExtendVo = companyExtendDao.load(companyExtendGetReqVo, CompanyExtendVo.class);
        if (null != companyExtendVo) {
            resVo.setCompanyExtendVo(companyExtendVo);
        }
        /*获取公司银行卡列表*/
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setCompanyId(reqVo.getId());
        companyBankCardGetReqVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(companyBankCardGetReqVo, CompanyBankCardVo.class);
        if (null != companyBankCardVo) {
            resVo.setBankCardVo(companyBankCardVo);
        }
        return resVo;
    }

    /**
     * 新增用户表（密码为123456），公司主表，公司扩展表，商户表，银行卡表（企业类型有，个人类型没有）
     *
     * @param reqVo 公司以及公司扩展表信息
     * @return 公司id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo saveCompany(SaveCompanyReqVo reqVo) {
        /*返回结果对象*/
        SaveCompanyResVo resVo = new SaveCompanyResVo();
        /*检查用户名*/
        if (!StringHelper.isEmpty(reqVo.getAccount())) {
            userService.isValid(reqVo.getAccount());
            UserVo userReqVo = new UserVo();
            userReqVo.setAccount(reqVo.getAccount());
            if (null != reqVo.getUserId() && !reqVo.getUserId().isEmpty()) {
                userReqVo.setId(reqVo.getUserId());
            }
            userService.checkAccount(userReqVo);
        }

        /*公司主表*/
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(reqVo.getCompanyId() != null ? reqVo.getCompanyId() : StringHelper.getNewID());
        ObjectHelper.writeWithFrom(companyVo, reqVo);
        companyVo.setAddress(reqVo.getCompanyAddress());
        companyVo.setProductOrInterface(CompanyConstant.PRODUCT);
        companyVo.setStatus(reqVo.getStatus() != null ? reqVo.getStatus() : 0);
        companyVo.setExamineStatus(0);

        /*注册服务请求对象*/
        CompanyReqVo companyReqVo = new CompanyReqVo();
        companyReqVo.setBankList(new ArrayList<CompanyBankReqVo1>());
        ObjectHelper.writeWithFrom(companyReqVo, companyVo);
        companyReqVo.setCompanyAttribution(reqVo.getCompanyAttribute());

        /*银行卡*/
        if (reqVo.getCompanyType() == 1) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            ObjectHelper.writeWithFrom(companyBankCardVo, reqVo);
            companyBankCardVo.setId(!StringHelper.isEmpty(reqVo.getCompanyBankCardId()) ? reqVo.getCompanyBankCardId() : StringHelper.getNewID());
            companyBankCardVo.setName(reqVo.getContactName());
            companyBankCardVo.setReservedPhone(reqVo.getContactPhone());
            companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
            companyBankCardVo.setType(reqVo.getCompanyType());
            companyBankCardVo.setIdCard(reqVo.getContactCode());
            companyBankCardVo.setCompanyId(companyVo.getId());

            CompanyBankReqVo1 companyBankReqVo1 = new CompanyBankReqVo1();
            ObjectHelper.writeWithFrom(companyBankReqVo1, companyBankCardVo);
            companyReqVo.getBankList().add(companyBankReqVo1);
        }
        /*注册*/
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("获取失败，请重试");
        }
        CompanyReqVo res = (CompanyReqVo) result.getData();
        CompanyVo companyVo1 = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo1, res);
        companyVo1.setProductOrInterface(companyVo.getProductOrInterface());
        companyVo1.setExamineStatus(companyVo.getExamineStatus());
        companyVo1.setCompanyAttribute(companyReqVo.getCompanyAttribution());

        /*保存公司主表*/
        if (!StringHelper.isEmpty(reqVo.getCompanyId())) {
            companyDao.update(companyVo1);
        } else {
            companyDao.create(companyVo1);
        }

        resVo.setCompanyId(companyVo1.getId());
        resVo.setStatus(companyVo1.getStatus());

        /*保存银行卡表*/
        List<CompanyBankReqVo1> companyBankReqVo1List = res.getBankList();
        if (null != companyBankReqVo1List && !companyBankReqVo1List.isEmpty()) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            CompanyBankReqVo1 companyBankReqVo1 = companyBankReqVo1List.get(0);
            ObjectHelper.writeWithFrom(companyBankCardVo, companyBankReqVo1);
            companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);

            if (!StringHelper.isEmpty(reqVo.getCompanyBankCardId())) {
                companyBankCardDao.update(companyBankCardVo);
            } else {
                companyBankCardDao.create(companyBankCardVo);
            }

            resVo.setCompanyBankCardId(companyBankCardVo.getId());
        }

        /*保存公司扩展表*/
        CompanyExtendVo extendVo = new CompanyExtendVo();
        extendVo.setId(companyVo.getId());
        String qrCode = DateHelper.getNow()
                .replace("-", "")
                .replace(":", "")
                .replace(" ", "");
        extendVo.setQrCode(qrCode);
        if (!StringHelper.isEmpty(reqVo.getCompanyExtendId())) {
            companyExtendDao.update(extendVo);
        } else {
            companyExtendDao.create(extendVo);
        }
        resVo.setCompanyExtendId(extendVo.getId());

        /*保存商户表*/
        MerchantCreateReqVo merchantCreateReqVo = new MerchantCreateReqVo();

        merchantCreateReqVo.setId(reqVo.getMerchantId() != null ? reqVo.getMerchantId() : StringHelper.getNewID());
        merchantCreateReqVo.setType(reqVo.getCompanyAttribute());
        merchantCreateReqVo.setName(reqVo.getMerchantName());
        merchantCreateReqVo.setAddress(reqVo.getMerchantAddress());
        merchantCreateReqVo.setUserId(reqVo.getCreateId());
        merchantCreateReqVo.setUsername(reqVo.getCreateName());
        merchantCreateReqVo.setProductCompanyId(companyVo.getId());


        ResponseResult result1 = storeFeign.merchantCreate(merchantCreateReqVo);
        if (null == result1 || !"00".equals(result1.getCode())) {
            throw new CodeException("获取失败，请重试");
        }
        String merchantId = (String) result1.getData();
        resVo.setMerchantId(merchantId);

        /*保存用户*/
        UserVo userVo = new UserVo();
        if (StringHelper.isEmpty(reqVo.getUserId())) {
            userVo.setId(StringHelper.getNewID());
            userVo.setPassword(StringHelper.md5("123456"));
            userVo.setRemark("123456");
            userVo.setCreateId(reqVo.getCreateId());
            userVo.setCreateName(reqVo.getCreateName());
            userVo.setCompanyId(companyVo.getId());
            userVo.setIsFirst(1);
        } else {
            UserGetReqVo userGetReqVo = new UserGetReqVo();
            userGetReqVo.setId(reqVo.getUserId());
            userVo = userDao.load(userGetReqVo, UserVo.class);
        }
        userVo.setAccount(reqVo.getAccount());
        userVo.setName(reqVo.getContactName());
        userVo.setPhone(reqVo.getContactPhone());

        /*检查手机是否存在*/
        /*userServiceImpl.checkPhone(userVo);*/
        if (!StringHelper.isEmpty(reqVo.getUserId())) {
            userDao.update(userVo);
        } else {
            userDao.create(userVo);
        }

        resVo.setUserId(userVo.getId());

        return resVo;
    }

    /**
     * 添加公司提交按钮
     *
     * @param reqVo 封装了公司id和验证码的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaveCompanyResVo companySubmit(SaveCompanyReqVo reqVo) {
        /*返回对象*/
        SaveCompanyResVo resVo = new SaveCompanyResVo();
        /*公司主表*/
        CompanyVo companyVo = companyDao.load(reqVo.getCompanyId(), CompanyVo.class);
        companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
        companyVo.setCompanyName(reqVo.getCompanyName());
        companyVo.setAddress(reqVo.getCompanyAddress());
        companyVo.setBusinessLicenseCode(reqVo.getBusinessLicenseCode());
        companyVo.setContactName(reqVo.getContactName());
        companyVo.setContactCode(reqVo.getContactCode());
        companyVo.setContactPhone(reqVo.getContactPhone());
        companyVo.setUpdateTime(DateHelper.getNow());

        resVo.setCompanyId(companyVo.getId());
        resVo.setCompanyExtendId(companyVo.getId());
        /*注册请求对象*/
        CompanyReqVo companyReqVo = new CompanyReqVo();
        companyReqVo.setBankList(new ArrayList<CompanyBankReqVo1>());
        ObjectHelper.writeWithFrom(companyReqVo, companyVo);
        if (null != reqVo.getVerifyCode() && !reqVo.getVerifyCode().isEmpty()) {
            companyReqVo.setValidateCode(reqVo.getVerifyCode());
        }
        companyReqVo.setId(reqVo.getId());

        /*银行卡*/
        if (null != reqVo.getCompanyBankCardId() && !reqVo.getCompanyBankCardId().isEmpty()) {
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(reqVo.getCompanyBankCardId(), CompanyBankCardVo.class);
            companyBankCardVo.setName(reqVo.getContactName());
            companyBankCardVo.setIdCard(reqVo.getContactCode());
            companyBankCardVo.setReservedPhone(reqVo.getContactPhone());
            companyBankCardVo.setBankName(reqVo.getBankName());
            companyBankCardVo.setBankAddress(reqVo.getBankAddress());
            companyBankCardVo.setBankCardCode(reqVo.getBankCardCode());
            companyBankCardVo.setBankCode(reqVo.getBankCode());
            CompanyBankReqVo1 companyBankReqVo1 = new CompanyBankReqVo1();
            ObjectHelper.writeWithFrom(companyBankReqVo1, companyBankCardVo);
            companyReqVo.getBankList().add(companyBankReqVo1);

            resVo.setCompanyBankCardId(companyBankCardVo.getId());
        }

        /*注册服务验证验证码*/
        ResponseResult result = payFeign.setCompanyInfo(companyReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("验证失败，请重试");
        }

        /*更新公司主表*/
        CompanyReqVo res = (CompanyReqVo) result.getData();
        CompanyVo companyVo1 = new CompanyVo();
        ObjectHelper.writeWithFrom(companyVo1, res);
        companyVo1.setProductOrInterface(companyVo.getProductOrInterface());
        companyVo1.setExamineStatus(companyVo.getExamineStatus());
        companyVo1.setCompanyAttribute(companyVo.getCompanyAttribute());
        companyDao.update(companyVo1);

        /*更新银行卡表*/
        List<CompanyBankReqVo1> companyBankReqVo1List = res.getBankList();
        if (null != companyBankReqVo1List && !companyBankReqVo1List.isEmpty()) {
            CompanyBankCardVo companyBankCardVo = new CompanyBankCardVo();
            CompanyBankReqVo1 companyBankReqVo1 = companyBankReqVo1List.get(0);
            ObjectHelper.writeWithFrom(companyBankCardVo, companyBankReqVo1);
            companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
            companyBankCardDao.update(companyBankCardVo);
        }

        /*更新商户表*/
        MerchantCreateReqVo merchantCreateReqVo = new MerchantCreateReqVo();

        CompanyScenicInfoReqVo companyScenicInfoReqVo = new CompanyScenicInfoReqVo();
        ObjectHelper.writeWithFrom(companyScenicInfoReqVo, companyVo);
        companyScenicInfoReqVo.setCompanyId(companyVo.getId());
        companyScenicInfoReqVo.setReqId(reqVo.getReqId());
        companyScenicInfoReqVo.setProductOrInterface(companyVo.getProductOrInterface());
        ResponseResult result1 = storeFeign.getCompanyScenicInfo(companyScenicInfoReqVo);
        if (null == result1 || !"00".equals(result1.getCode())) {
            throw new CodeException("验证失败，请重试");
        }
        MerchantVo merchant = (MerchantVo) result1.getData();
        ObjectHelper.writeWithFrom(merchantCreateReqVo, merchant);
        merchantCreateReqVo.setReqId(reqVo.getReqId());
        merchantCreateReqVo.setType(reqVo.getCompanyAttribute());
        merchantCreateReqVo.setName(reqVo.getMerchantName());
        merchantCreateReqVo.setAddress(reqVo.getMerchantAddress());

        resVo.setMerchantId(merchant.getId());

        ResponseResult result2 = storeFeign.merchantCreate(merchantCreateReqVo);
        if (null == result2 || !"00".equals(result2.getCode())) {
            throw new CodeException("验证失败，请重试");
        }

        /*更新用户表*/
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setId(reqVo.getUserId());
        UserVo userVo = userDao.load(userGetReqVo, UserVo.class);
        userVo.setAccount(reqVo.getAccount());
        userVo.setName(reqVo.getContactName());
        userVo.setPhone(reqVo.getContactPhone());
        /*userServiceImpl.checkPhone(userVo);*/
        userDao.update(userVo);

        resVo.setUserId(userVo.getId());
        return resVo;
    }

    /**
     * 修改公司审核状态
     *
     * @param reqVo 封装了公司id 的请求对象
     * @return
     */
    @Override
    public void updateExamine(UpdateExamineReqVo reqVo) {

        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        getReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDao.load(getReqVo, CompanyVo.class);
        companyVo.setExamineStatus(reqVo.getExamineStatus());
        companyVo.setUpdateTime(DateHelper.getNow());
        companyDao.update(companyVo);
    }

    /**
     * 保存/更新银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResponseResult<CompanyBankCardVo> saveBank(CompanyBankCardReqVo reqVo) {
        CompanyVo companyVo = companyDao.load(reqVo.getCompanyId(), CompanyVo.class);
        if(StringHelper.isEmpty(companyVo)){
            throw new CodeException("用户信息没有找到。");
        }
        // 判断银行卡是否存在
        Date date = DateHelper.getDateTime(companyVo.getCreateTime());
        String bankId = StringHelper.getNewIdMD5(date, companyVo.getId(), reqVo.getBankCardCode());
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(bankId, CompanyBankCardVo.class);
        // 银行卡不为空，并且状态为已绑定成功
        if (!StringHelper.isEmpty(companyBankCardVo)) {
            if (com.pangding.web.constant.CompanyConstant.BANK_STATUS_SUCCESS == companyBankCardVo.getStatus()) {
                throw new CodeException("银行卡已绑定，不可修改。");
            }
            /*此处需要调用第三方接口发送手机验证码，并修改数据库状态*/
            ObjectHelper.writeWithFrom(reqVo, companyBankCardVo);
            reqVo.setReservedPhone(reqVo.getPhone());
            ResponseResult<CompanyBankCardReqVo> result = payFeign.bindBack(reqVo);
            if (null == result || !"00".equals(result.getCode())) {
                throw new CodeException("绑定银行卡失败，请重试");
            }
            CompanyBankCardReqVo resVo = result.getData();
            ObjectHelper.writeWithFrom(companyBankCardVo, resVo);
            companyBankCardVo.setIsDefault(0);
            companyBankCardDao.update(companyBankCardVo);
            if(1 == companyBankCardVo.getStatus()){
                return ResponseResult.error("99", "该银行卡已绑定");
            }
        } else {
            companyBankCardVo = new CompanyBankCardVo();
//            companyBankCardVo.setId(bankId);
            /*此处需要调用第三方接口发送手机验证码，并修改数据库状态*/
            reqVo.setId(bankId);
            reqVo.setReservedPhone(reqVo.getPhone());
            reqVo.setStatus(0);
            ResponseResult<CompanyBankCardReqVo> result = payFeign.bindBack(reqVo);
            if (null == result || !"00".equals(result.getCode())) {
                throw new CodeException("绑定银行卡失败，请重试");
            }
            CompanyBankCardReqVo resVo = result.getData();
            ObjectHelper.writeWithFrom(companyBankCardVo, resVo);
//            companyBankCardVo.setIsDefault(reqVo.getIsDefault());
            BankCardListReqVo reqVo1 = new BankCardListReqVo();
            reqVo1.setCompanyId(reqVo.getCompanyId());
            PageSizeData<CompanyBankCardVo> companyBankCardDaoBankCardList = companyBankCardDao.getBankCardList(reqVo1);
             /*若该银行卡是第一张银行卡，则设为默认*/
            if (null == companyBankCardDaoBankCardList || companyBankCardDaoBankCardList.getList().isEmpty()) {
                reqVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
            } else {
                reqVo.setIsDefault(CompanyBankCardConstant.IS_NOT_DEFAULT);
            }
            reqVo.setStatus(0);
            companyBankCardDao.create(companyBankCardVo);
            if(1 == companyBankCardVo.getStatus()){
                return ResponseResult.error("99", "该银行卡已绑定");
            }
        }
        return ResponseResult.result(companyBankCardVo);
    }

    /**
     * 调用支付服务解绑银行卡，并更新银行卡状态
     *
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBank(CompanyBankCardVo reqVo) {
        CompanyBankCardVo bankCardVo = companyBankCardDao.load(reqVo.getId(), CompanyBankCardVo.class);
        CompanyBankCardReqVo companyBankCardReqVo = new CompanyBankCardReqVo();
        ObjectHelper.writeWithFrom(companyBankCardReqVo, bankCardVo);
        ResponseResult result = payFeign.unbindBankCard(companyBankCardReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("解绑失败，请重试");
        }
        /*若删除的银行卡为默认银行卡，则需要设置其他一张卡为默认银行卡*/
        if (CompanyBankCardConstant.IS_DEFAULT.equals(bankCardVo.getIsDefault())) {
            CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
            getReqVo.setCompanyId(bankCardVo.getCompanyId());
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);
            if (null != companyBankCardVo) {
                companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
                companyExtendDao.update(companyBankCardVo);
            }
        }
        companyBankCardDao.remove(bankCardVo);
    }

    /**
     * 设置该银行卡为默认支付，并取消其他银行卡的默认
     *
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void setDefault(CompanyBankCardVo reqVo) {
        /*获取该银行卡的公司id*/
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(reqVo, CompanyBankCardVo.class);
        String companyId = companyBankCardVo.getCompanyId();
        /*现将该公司其他银行卡设为非默认*/
        CompanyBankCardSetNotDefaultReqVo setNotDefaultReqVo = new CompanyBankCardSetNotDefaultReqVo();
        setNotDefaultReqVo.setCompanyId(companyId);
        companyBankCardDao.setNotDefault(setNotDefaultReqVo);
        /*将该卡设置为默认银行卡并更新*/
        companyBankCardVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        companyBankCardDao.update(companyBankCardVo);
    }

    /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     *
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CompanyBankCardVo bankSubmit(BankSubmitReqVo reqVo) {
        /*根据银行卡id获取银行卡信息*/
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setId(reqVo.getId());
        CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(getReqVo, CompanyBankCardVo.class);

        /*此处应该将companyBankCardVo和verifyCode发送到第三方接口，获取到的返回值用于更新银行卡状态*/
        CompanyBankCardReqVo companyBankCardReqVo = new CompanyBankCardReqVo();
        ObjectHelper.writeWithFrom(companyBankCardReqVo, companyBankCardVo);
        companyBankCardReqVo.setPhone(companyBankCardVo.getReservedPhone());
        companyBankCardReqVo.setValidateCode(reqVo.getVerifyCode());
        ResponseResult<CompanyBankCardReqVo> result = payFeign.bindBack(companyBankCardReqVo);
        if (null == result || !"00".equals(result.getCode())) {
            throw new CodeException("绑定银行卡失败，请重试");
        }
        CompanyBankCardReqVo resVo =  result.getData();
        ObjectHelper.writeWithFrom(companyBankCardVo, resVo);
        companyBankCardDao.update(companyBankCardVo);

        return companyBankCardVo;
    }

    /**
     * y
     * 我的二维码页面
     *
     * @param reqVo 公司扩展表请求对象
     * @return 公司主表信息
     */
    @Override
    public CompanyVo myQrCodeUrl(CompanyGetReqVo reqVo) {
        CompanyVo companyVo = companyDao.load(reqVo, CompanyVo.class);
        if (null == companyVo) {
            throw new CodeException("暂无公司信息");
        }
        return companyVo;
    }

    /**
     * 获取二维码url，有则直接返回，没有则调用微信服务生成url
     *
     * @param reqVo 封装了公司id，页面选项的请求对象
     * @return 二维码url
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String generateQrCodeUrl(GenerateQrCodeUrlReqVo reqVo) {
        com.pangding.web.vo.system.res.company.CompanyResVo companyResVo = companyDao.load(reqVo.getCompanyId(), com.pangding.web.vo.system.res.company.CompanyResVo.class);
//        CompanyExtendVo companyExtendVo = companyExtendDao.load(reqVo.getCompanyId(), CompanyExtendVo.class);
        CompanyExtendVo companyExtendVo = new CompanyExtendVo();
        if (StringHelper.isEmpty(companyResVo)) {
           throw new CodeException("公司信息不存在");
        }
        ObjectHelper.writeWithFrom(companyExtendVo, companyResVo);
        if(StringHelper.isEmpty(companyResVo.getQrCode())){
            String code = DateHelper.getNow()
                    .replace("-", "")
                    .replace(":", "")
                    .replace(" ", "");
            ObjectHelper.writeWithFrom(companyExtendVo, companyResVo);
            companyExtendVo.setQrCode(code);
        }
        int select = reqVo.getSelect();
        /*此处应调用微信接口传入qrCode和select获取qrCodeUrl*/
        QrCodeReqVo qrCodeReqVo = new QrCodeReqVo();
        qrCodeReqVo.setReqId(reqVo.getReqId());
        /*临时二维码，超时时间30分钟*/
        SceneInfo sceneInfo = new SceneInfo();
        Scene scene = new Scene();
        scene.setScene_str(companyExtendVo.getQrCode());
        sceneInfo.setScene(scene);
        qrCodeReqVo.setAction_info(sceneInfo);
//            if (select == 0) {
//                qrCodeReqVo.setExpire_seconds(60 * 30);
//                qrCodeReqVo.setAction_name("QR_STR_SCENE");
//            } else {
        qrCodeReqVo.setAction_name("QR_LIMIT_STR_SCENE");
//            }
        ResponseResult result;
        try {
            result = wxFeign.qcCodeGet(qrCodeReqVo);
        } catch (CodeException e) {
            throw new CodeException(e.getCode(), e.getMessage());
        }

        WxVo wxVo = (WxVo) result.getData();
        String url = wxVo.getPdUrl();
        if ("QR_LIMIT_STR_SCENE".equals(qrCodeReqVo.getAction_name())) {
            companyExtendVo.setQrCodeUrl(url);
            companyExtendDao.update(companyExtendVo);
        }
        com.pangding.web.vo.system.req.CompanyMsgReqVo companyMsgReqVo = new com.pangding.web.vo.system.req.CompanyMsgReqVo();
        companyMsgReqVo.setCompanyId(companyResVo.getId());
        companyMsgReqVo.setMerchantId("");
        CompanyMsgVo companyMsgVo = companyMsgDao.load(companyMsgReqVo, CompanyMsgVo.class);
        if(StringHelper.isEmpty(companyMsgVo)){
            companyMsgVo = new CompanyMsgVo();
            companyMsgVo.setId(StringHelper.getNewID());
            companyMsgVo.setCompanyId(companyResVo.getId());
            companyMsgVo.setMerchantId(reqVo.getMerchantId());
            companyMsgVo.setCompanyName(companyResVo.getCompanyName());
            companyMsgVo.setMerchantName("");
            companyMsgVo.setMsgId("4");
            companyMsgVo.setMsgLocation(1);
            companyMsgVo.setType(companyResVo.getCompanyAttribute());
            companyMsgDao.create(companyMsgVo);
        }
        return url;

    }

    /**
     * 获取银行卡列表
     *
     * @param reqVo 继承了分页对象，含公司id
     * @return 银行卡列表分页对象
     */
    @Override
    public PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo) {

        PageSizeData<CompanyBankCardVo> companyBankCardVoPageSizeData = companyBankCardDao.getBankCardList(reqVo);
//        if (companyBankCardVoPageSizeData == null || companyBankCardVoPageSizeData.getList().isEmpty()) {
//            throw new CodeException("暂无银行卡，请先添加");
//        }
        return companyBankCardVoPageSizeData;
    }

    /**
     * 添加用户
     *
     * @param reqVo 封装了用户信息和用户角色信息的请求对象
     * @return 用户id
     */
    @Override
    public String saveUser(WebUserReqVo reqVo) throws Exception {
        return userService.saveUser(reqVo);
    }

    /**
     * 根据请求的数据返回对应的供应商或是接口商列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<CompanyVo> productOrInterface(ProductOrInterfaceReqVo reqVo) {
        CompanyGetReqVo getReqVo = new CompanyGetReqVo();
        ObjectHelper.writeWithFrom(getReqVo, reqVo);
        List<CompanyVo> companyVoList = companyDao.loadList(getReqVo, CompanyVo.class);
        if (null == companyVoList || companyVoList.isEmpty()) {
            throw new CodeException("未找到公司信息");
        }
        return companyVoList;
    }

    /**
     * 批量删除用户
     *
     * @param reqVo 封装了用户id列表的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchDelete(BatchDeleteReqVo reqVo) {
        List<String> userIdList = reqVo.getUserIdList();
        if (null == userIdList || userIdList.isEmpty()) {
            throw new CodeException("删除列表为空，请添加");
        }
        for (String userId : userIdList) {
            UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
            userRoleGetReqVo.setUserId(userId);
            List<UserRoleVo> userRoleVoList = userRoleDao.loadList(userRoleGetReqVo, UserRoleVo.class);
            if (null != userRoleVoList && userRoleVoList.size() == 1) {
                UserRoleGetReqVo userRoleGetReqVo1 = new UserRoleGetReqVo();
                userRoleGetReqVo1.setUserId(userId);
                userRoleGetReqVo1.setRoleId(reqVo.getRoleId());
                UserRoleVo userRoleVo = userRoleDao.load(userRoleGetReqVo1, UserRoleVo.class);
                userRoleDao.remove(userRoleVo);
                UserGetReqVo userGetReqVo = new UserGetReqVo();
                userGetReqVo.setId(userId);
                UserVo userVo = userDao.load(userGetReqVo, UserVo.class);
                userVo.setStatus(1);
                userDao.update(userVo);
            } else if (null != userRoleVoList && userRoleVoList.size() > 1) {
                UserRoleGetReqVo userRoleGetReqVo1 = new UserRoleGetReqVo();
                userRoleGetReqVo1.setUserId(userId);
                userRoleGetReqVo1.setRoleId(reqVo.getRoleId());
                UserRoleVo userRoleVo = userRoleDao.load(userRoleGetReqVo1, UserRoleVo.class);
                userRoleDao.remove(userRoleVo);
            }
        }
    }

    /**
     * 批量更新用户信息
     *
     * @param reqVo 封装了用户列表的请求对象
     * @return
     */
    @Override
    public void batchUpdate(BatchUpdateReqVo reqVo) throws Exception {
        List<UserVo> userVoList = reqVo.getUserVoList();
        if (null == userVoList || userVoList.isEmpty()) {
            throw new CodeException("更新列表为空，请添加");
        }
        for (UserVo userVo : userVoList) {
            UserGetReqVo getReqVo = new UserGetReqVo();
            getReqVo.setId(userVo.getId());
            UserVo userVoOld = userDao.load(getReqVo, UserVo.class);
            if (!StringHelper.compare(userVo.getAccount(), userVoOld.getAccount())) {
                userService.isValid(userVo.getAccount());
                userService.checkAccount(userVo);
            }
            if ("".equals(userVo.getPassword())) {
                userVo.setPassword(userVoOld.getPassword());
                userVo.setRemark(userVoOld.getRemark());
            } else {
                String password = RSAUtils.decryptionByPrivateKey(userVo.getPassword(), RsaConstant.privateKey);
                userVo.setPassword(StringHelper.md5(password));
                userVo.setRemark(password);
            }
            if (!StringHelper.compare(userVo.getEmail(), userVoOld.getEmail())) {
                userService.checkEmail(userVo.getEmail());
            }
            if (!StringHelper.compare(userVo.getPhone(), userVoOld.getPhone())) {
                userService.checkPhone(userVo);
            }
            userDao.update(userVo);
        }
    }

    /**
     * 通过公司id查询该公司邀请的公司
     *
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public PageSizeData<CompanyVo> myInvite(ListCompanyReqVo reqVo) {
        return companyDao.getCompanyList(reqVo);
    }

    @Override
    public String invitation(InvitationReqVo reqVo) {
        return pangdingPartnerService.invitation(reqVo);
    }

    /**
     * 根据二维码源码获取公司数据
     *
     * @param reqVo 封装了二维码源码的请求对象
     * @return
     */
    @Override
    public GetCompanyResVo getCompanyByQrCode(GetCompanyByQrCodeReqVo reqVo) {
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setQrCode(reqVo.getQrCode());
        CompanyExtendVo companyExtendVo = companyExtendDao.load(companyExtendGetReqVo, CompanyExtendVo.class);
        if (null != companyExtendVo) {
            CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
            companyGetReqVo.setId(companyExtendVo.getId());
            GetCompanyResVo companyVo = companyDao.load(companyGetReqVo, GetCompanyResVo.class);
            if (null != companyVo) {
                CompanyMsgReqVo companyMsgReqVo = new CompanyMsgReqVo();
                companyMsgReqVo.setCompanyId(companyVo.getId());
                companyMsgReqVo.setType(companyVo.getCompanyAttribute());
                List<GetCompanyMsgResVo> companyMsgVoList = companyMsgDao.findCompanyMsgList(companyMsgReqVo);
                companyVo.setMsgList(companyMsgVoList);
            }
            return companyVo;
        }
        return null;
    }

    @Override
    public List<GetCompanyDivideResVo> findCompanyDivideInfo(CompanyDivideReqVo req) {
        List<GetCompanyDivideResVo> companyDivideResVoList = new ArrayList<>();
        List<GetCompanyReqVo> companyList = req.getCompanyIdList();
        for (int i = 0; i < companyList.size(); i++) {
            GetCompanyReqVo getCompanyReqVo = companyList.get(i);
            GetCompanyDivideResVo companyDivideResVo = companyDivideRuleDao.findCompanyDivideInfo(getCompanyReqVo);
            companyDivideResVo.setCompanyChannelType(getCompanyReqVo.getCompanyChannelType());
            companyDivideResVoList.add(companyDivideResVo);
        }
        return companyDivideResVoList;
    }

    /**
     * 检查邀请码是否真实存在
     *
     * @param reqVo
     * @return
     */
    @Override
    public CompanyVo checkInvitationCode(CheckInvitationCodeReqVo reqVo) {
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setInvitationCode(reqVo.getInvitationCode());
        CompanyExtendVo companyExtendVo = companyExtendDao.load(companyExtendGetReqVo, CompanyExtendVo.class);
        if (null == companyExtendVo) {
            throw new CodeException("该邀请码为错误邀请码");
        }
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(companyExtendVo.getId());
        return companyDao.load(companyGetReqVo, CompanyVo.class);
    }

    /**
     * 审核公司
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void examineConfig(ExamineConfigReqVo reqVo) {
        /*更新公司表*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(reqVo.getCompanyId());
        CompanyVo companyVo = companyDao.load(companyGetReqVo, CompanyVo.class);
        companyVo.setExamineStatus(reqVo.getExamineStatus());
        companyVo.setExamineFailedReason(reqVo.getExamineFailedReason());
        companyDao.update(companyVo);
        /*更新公司扩展表*/
        CompanyExtendGetReqVo companyExtendGetReqVo = new CompanyExtendGetReqVo();
        companyExtendGetReqVo.setId(reqVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDao.load(companyExtendGetReqVo, CompanyExtendVo.class);
        if (null == companyExtendVo) {
            companyExtendVo = new CompanyExtendVo();
            companyExtendVo.setId(reqVo.getCompanyId());
            companyExtendVo.setQrCode(DateHelper.getNow()
                    .replace("-", "")
                    .replace(":", "")
                    .replace(" ", ""));
            companyExtendVo.setWithdrawMoney(reqVo.getWithdrawMoney());
            companyExtendVo.setWithdrawRule(reqVo.getWithdrawRule());
            companyExtendVo.setWithdrawFee(reqVo.getWithdrawFee());
            companyExtendVo.setQrCodeType(reqVo.getQrCodeType());
            companyExtendDao.create(companyExtendVo);
        } else {
            companyExtendVo.setWithdrawMoney(reqVo.getWithdrawMoney());
            companyExtendVo.setWithdrawRule(reqVo.getWithdrawRule());
            companyExtendVo.setWithdrawFee(reqVo.getWithdrawFee());
            companyExtendVo.setQrCodeType(reqVo.getQrCodeType());
            companyExtendDao.update(companyExtendVo);
        }
        /*新增或更新pd_company_divide_rule表*/
        CompanyDivideRuleVo companyDivideRuleVo = new CompanyDivideRuleVo();
        ObjectHelper.writeWithFrom(companyDivideRuleVo, reqVo);
        CompanyDivideRuleGetReqVo companyDivideRuleGetReqVo = new CompanyDivideRuleGetReqVo();
        companyDivideRuleGetReqVo.setCompanyId(reqVo.getCompanyId());
        CompanyDivideRuleVo companyDivideRuleResVo = companyDivideRuleDao.load(companyDivideRuleGetReqVo, CompanyDivideRuleVo.class);
        if (null == companyDivideRuleResVo) {
            companyDivideRuleVo.setId(StringHelper.getNewID());
            companyDivideRuleDao.create(companyDivideRuleVo);
        } else {
            companyDivideRuleVo.setId(companyDivideRuleResVo.getId());
            companyDivideRuleVo.setFee(companyDivideRuleResVo.getFee());
            companyDivideRuleVo.setBonusType(companyDivideRuleResVo.getBonusType());
            companyDivideRuleVo.setBonusValue(companyDivideRuleResVo.getBonusValue());
            companyDivideRuleVo.setRealBonusValue(companyDivideRuleResVo.getRealBonusValue());
            companyDivideRuleVo.setBonusExplain(companyDivideRuleResVo.getBonusExplain());
            companyDivideRuleDao.update(companyDivideRuleVo);
        }
        /*更新角色表*/
        RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
        roleGetReqVo.setId(reqVo.getRoleId());
        RoleVo roleVo = roleDao.load(roleGetReqVo, RoleVo.class);
        roleVo.setCompanyId(reqVo.getCompanyId());
        roleVo.setIsAdmin(1);
        roleDao.update(roleVo);
        /*保存用户角色关系*/
        UserRoleVo userRoleVo = new UserRoleVo();
        userRoleVo.setId(StringHelper.getNewID());
        userRoleVo.setUserId(reqVo.getUserId());
        userRoleVo.setRoleId(roleVo.getId());
        userRoleDao.create(userRoleVo);
    }


    @Override
    public ResponseResult<String> updateCompanyMoney(CompanyMoneyUpdateReqVo req) {
        CompanyVo companyVo = companyDao.load(req.getCompanyId(), CompanyVo.class);
        CompanyExtendVo companyExtendVo = companyExtendDao.load(req.getCompanyId(), CompanyExtendVo.class);
        if (StringHelper.isEmpty(companyVo) || StringHelper.isEmpty(companyExtendVo)) {
            throw new CodeException("未找到公司信息");
        }
        try {
            // 可提现余额
            double companyMoney = companyExtendVo.getWithdrawTotalCash();
//            req = new UpdateCompanyMoneyReqVo();
//            req.setCompanyId(companyVo.getId());

            if (OrderConstant.CATEGORY_ENTRY == req.getMoneyType()
                    || OrderConstant.CATEGORY_DIVIDEND == req.getMoneyType()
                    || OrderConstant.CATEGORY_RECHARGE == req.getMoneyType()) {
                // 分账 转账 充值
                companyMoney += req.getMoney();
            }
            if (OrderConstant.CATEGORY_REFUND == req.getMoneyType()
                    || OrderConstant.CATEGORY_WITHDRAWAL == req.getMoneyType()) {
                // 退款 提现
                companyMoney -= req.getMoney();
            }
//            int orderMoneyType = 0;
//            int divideMoneyType = 0;
//            List<CompanyMoneyDateilVo> companyMoneyDateilVoList = companyMoneyDetailDao.loadList(req, CompanyMoneyDateilVo.class);
//            for(int i = 0; i < companyMoneyDateilVoList.size(); i++){
//                CompanyMoneyDateilVo companyMoneyDateilVo = companyMoneyDateilVoList.get(i);
//                if(CompanyConstant.MONEY_TYPE_ORDER == companyMoneyDateilVo.getMoneyType()){
//                    orderMoneyType = 1;
//                    if(CompanyConstant.MONEY_TYPE_REFUND == req.getMoneyType()){
//                        companyMoneyDateilVo.setMoney(companyMoneyDateilVo.getMoney() - money);
//                        companyMoneyDetailDao.update(companyMoneyDateilVo);
//                    }else{
//                        companyMoneyDateilVo.setMoney(companyMoneyDateilVo.getMoney() + addMoney);
//                        companyMoneyDetailDao.update(companyMoneyDateilVo);
//                    }
//                }
//                if(CompanyConstant.MONEY_TYPE_DIVIDE == companyMoneyDateilVo.getMoneyType()){
//                    divideMoneyType = 1;
//                    if(CompanyConstant.MONEY_TYPE_ZZ == req.getMoneyType()){
//                        companyMoneyDateilVo.setMoney(companyMoneyDateilVo.getMoney() + addMoney);
//                        companyMoneyDetailDao.update(companyMoneyDateilVo);
//                    }
//                }
//            }

            companyExtendVo.setWithdrawTotalCash(companyMoney);
            companyExtendDao.update(companyExtendVo);
            return ResponseResult.result("处理完成");
        } catch (CodeException e) {
            throw new CodeException("");
        }
    }

    @Override
    public FindCompanyBalanceResVo findCompanyBalance(com.pangding.web.vo.system.req.company.CompanyReqVo req) {

        com.pangding.web.vo.system.res.company.CompanyResVo companyResVo = companyDao.load(req.getId(), com.pangding.web.vo.system.res.company.CompanyResVo.class);

        CompanyExtendResVo companyExtendResVo = companyExtendDao.load(req.getId(), CompanyExtendResVo.class);

        List<CompanyMoneyDetailResVo> companyMoneyDetailResVoList = companyMoneyDetailDao.loadList(
                new CompanyMoneyDetailReqVo(req.getId()), CompanyMoneyDetailResVo.class);
        FindCompanyBalanceResVo findCompanyBalanceResVo = new FindCompanyBalanceResVo();
        findCompanyBalanceResVo.setCompany(companyResVo);
        findCompanyBalanceResVo.setCompanyExtend(companyExtendResVo);
        findCompanyBalanceResVo.setCompanyMoneyDetailList(companyMoneyDetailResVoList);
        return findCompanyBalanceResVo;
    }


    public void automaticCashWithdrawal(com.pangding.web.vo.system.req.company.CompanyReqVo req) {
        PageSizeData<com.pangding.web.vo.system.pd.company.CompanyExtendVo> companyExtendVoPageSizeData = companyExtendDao.loadPage(req, com.pangding.web.vo.system.pd.company.CompanyExtendVo.class);
        List<com.pangding.web.vo.system.pd.company.CompanyExtendVo> companyExtendVoList = companyExtendVoPageSizeData.getList();
        PageSizeData<com.pangding.web.vo.system.pd.company.CompanyVo> companyVoPageSizeData = companyDao.loadPage(req, com.pangding.web.vo.system.pd.company.CompanyVo.class);
        List<com.pangding.web.vo.system.pd.company.CompanyVo> companyVoList = companyVoPageSizeData.getList();
        for (int i = 0; i < companyExtendVoList.size(); i++) {
            com.pangding.web.vo.system.pd.company.CompanyExtendVo companyExtendVo = companyExtendVoList.get(i);
            String companyId = companyExtendVoList.get(i).getId();
//            com.pangding.web.vo.system.pd.company.CompanyVo companyVo = companyExtendDaoImpl.load(companyId,
//                    com.pangding.web.vo.system.pd.company.CompanyVo.class);
            if (!StringHelper.isEmpty(companyExtendVo)) {
                int withdrawRule = companyExtendVo.getWithdrawRule();
                double withdrawTotalCash = companyExtendVo.getWithdrawTotalCash();
                if (0 == withdrawRule && withdrawTotalCash > 0) {
                    // 自动提现
                    CompanyBankCardReqVo companyBankCardReqVo = new CompanyBankCardReqVo();
                    companyBankCardReqVo.setCompanyId(companyId);
                    companyBankCardReqVo.setIsDefault(1);
                    com.pangding.web.vo.system.pd.company.CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(companyBankCardReqVo, com.pangding.web.vo.system.pd.company.CompanyBankCardVo.class);
                    if (!StringHelper.isEmpty(companyBankCardVo)) {
                        CapitalFlowReqVo capitalFlowReqVo = new CapitalFlowReqVo();
                        capitalFlowReqVo.setCompanyId(companyId);
                        capitalFlowReqVo.setBankId(companyBankCardVo.getId());
                        capitalFlowReqVo.setBankCardCode(companyBankCardVo.getBankCardCode());
                        capitalFlowReqVo.setOrderMoney(withdrawTotalCash);
                        companyProducer.applyWithdrawal(capitalFlowReqVo);
                    }
                }
            }
        }
    }

    @Override
    public ResponseResult<com.pangding.web.vo.system.req.company.SaveCompanyReqVo> updateCompanyInfo(com.pangding.web.vo.system.req.company.SaveCompanyReqVo req) {
        ResponseResult<com.pangding.web.vo.system.req.company.SaveCompanyReqVo> responseResult = new ResponseResult<>();
        com.pangding.web.vo.system.res.company.CompanyResVo companyResVo = companyDao.load(req.getCompanyVo().getId(), com.pangding.web.vo.system.res.company.CompanyResVo.class);
        if (StringHelper.isEmpty(companyResVo)) {
            // 公司信息为空
            return ResponseResult.error("99", "注册信息有误");
        }
        ObjectHelper.writeWithFrom(companyResVo, req.getCompanyVo());
        companyResVo.setAddress(req.getCompanyVo().getAddress());
        companyResVo.setUpdateTime(DateHelper.getNow());
        if (com.pangding.web.constant.CompanyConstant.COMPANY_STATUS_BIND_PHONE < companyResVo.getStatus()) {
            // 公司状态小于电话已绑定，已经通过通联实名认证，不可修改公司的基本信息
//            companyExtendDao.update(companyResVo);
        } else {
            CompanyVo companyVo = new CompanyVo();
            ObjectHelper.writeWithFrom(companyResVo, req.getCompanyVo());
            ObjectHelper.writeWithFrom(companyVo, companyResVo);
//            companyDao.update(companyResVo);
//            companyExtendDao.update(companyResVo);
        }
        if(com.pangding.web.constant.CompanyConstant.COMPANY_TYPE_PERSON == companyResVo.getCompanyType()){
            // 个人 TODO 调用通联实名制
            com.pangding.web.vo.system.req.company.SaveCompanyReqVo companyReqVo = new com.pangding.web.vo.system.req.company.SaveCompanyReqVo();
            companyReqVo.setCompanyVo(companyResVo);
            companyReqVo.setVerifyCode(req.getVerifyCode());
            responseResult = payFeign.setCompanyInfo1(companyReqVo);
        }
        if(com.pangding.web.constant.CompanyConstant.COMPANY_TYPE_COMPANY == companyResVo.getCompanyType() ){
            // 公司
            // 找到银行卡 TODO 1判断银行卡id是否存在，存在则查询银行卡
            Date date = DateHelper.getDateTime(companyResVo.getCreateTime());
            String bankId = StringHelper.getNewIdMD5(date, req.getCompanyVo().getId(), req.getCompanyBankCardVo().getBankCardCode());
            CompanyBankCardVo companyBankCardVo = companyBankCardDao.load(bankId, CompanyBankCardVo.class);
            if(StringHelper.isEmpty(companyBankCardVo)){
                companyBankCardVo = new CompanyBankCardVo();
               ObjectHelper.writeWithFrom(companyBankCardVo, req.getCompanyBankCardVo());
               companyBankCardVo.setId(bankId);
               companyBankCardVo.setName(req.getCompanyVo().getContactName());
               companyBankCardVo.setIdCard(req.getCompanyVo().getContactCode());
               companyBankCardVo.setCompanyId(req.getCompanyVo().getId());
               companyBankCardVo.setType(1);
               companyBankCardVo.setStatus(0);
               companyBankCardVo.setIsDefault(0);
               companyBankCardDao.create(companyBankCardVo);
            }else{
                ObjectHelper.writeWithFrom(companyBankCardVo, req.getCompanyBankCardVo());
                companyBankCardVo.setId(bankId);
                companyBankCardDao.update(companyBankCardVo);
            }
            // Todo 调用通联设置公司信息
            com.pangding.web.vo.system.req.company.SaveCompanyReqVo companyReqVo = new com.pangding.web.vo.system.req.company.SaveCompanyReqVo();
            companyReqVo.setCompanyVo(companyResVo);

            companyReqVo.setCompanyBankCardVo(companyBankCardVo);
            companyReqVo.setVerifyCode(req.getVerifyCode());
            System.out.println("=======companyReqVo======" + JsonHelper.serialize(companyReqVo));
            responseResult = payFeign.setCompanyInfo1(companyReqVo);
            System.out.println("=======responseResult======" + JsonHelper.serialize(responseResult));
            ObjectHelper.writeWithFrom(companyBankCardVo, responseResult.getData().getCompanyBankCardVo());
            if(StringHelper.isEmpty(responseResult.getData().getErrorMessage())){
                companyBankCardVo.setStatus(1);
                companyBankCardVo.setBindingTime(DateHelper.getNow());
                companyBankCardVo.setBindingCode("");
            }
            companyBankCardDao.update(companyBankCardVo);
        }
        com.pangding.web.vo.system.req.company.SaveCompanyReqVo saveCompanyReqVo = responseResult.getData();
        ObjectHelper.writeWithFrom(companyResVo, saveCompanyReqVo.getCompanyVo());
        companyDao.update(companyResVo);

        if(StringHelper.isEmpty(saveCompanyReqVo.getErrorMessage())){
            // 错误信息为空，发送验证码成功 修改信息成功
            return responseResult;
        }else{
            return ResponseResult.error("99", saveCompanyReqVo.getErrorMessage());
        }
    }




}
