package com.pangding.web.authority.controller.code;

import com.pangding.web.authority.service.code.CodeModelService;
import com.pangding.web.vo.system.pd.code.CodeModelVo;
import com.pangding.web.vo.system.req.code.CodeModelReqVo;
import com.pangding.web.vo.system.res.code.CodeModelResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/codeModel", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "码模本相关类", description = "码模本新增、修改、删除等操作")
public class CodeModelController {

    @Autowired
    private CodeModelService codeModelService;

    @RequestMapping(value = "/queryCodeModelPageList")
    @ApiOperation(value = "分页查询码模板列表", notes = "根据页码返回码模板列表")
    public ResponseResult<PageSizeData<CodeModelResVo>> queryCodeModelPageList(@RequestBody CodeModelReqVo req) {
        return ResponseResult.result(codeModelService.queryCodeModelPageList(req));
    }

    @RequestMapping(value = "/queryCodeModelList")
    @ApiModelProperty(value = "查询码模板列表", notes = "返回所有码模板")
    public ResponseResult<List<CodeModelResVo>> queryCodeModelList(@RequestBody CodeModelReqVo req) {
        return ResponseResult.result(codeModelService.queryCodeModelList(req));
    }

    @RequestMapping(value = "/queryList")
    @ApiModelProperty(value = "查询码模板列表包含扩展信息", notes = "返回所有码模板列表包含扩展信息")
    public ResponseResult<List<CodeModelResVo>> queryList(@RequestBody CodeModelReqVo req) {
        return ResponseResult.result(codeModelService.queryList(req));
    }

    @RequestMapping(value = "/queryCodeModel")
    @ApiModelProperty(value = "查询码模板详情", notes = "返回码模板详细信息")
    public ResponseResult<CodeModelResVo> queryCodeModel(@RequestBody CodeModelReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("codeModelId", req.getCodeModelId())
                .checkException();
        return ResponseResult.result(codeModelService.queryCodeModel(req));
    }

    @RequestMapping(value = "/saveCodeModel")
    @ApiModelProperty(value = "保存或者修改码模板", notes = "返回码模板保存信息")
    public ResponseResult<CodeModelVo> saveCodeModel(@RequestBody CodeModelReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("codeType", req.getCodeType())
                .notBlankCheck("codeModelName", req.getCodeModelName())
                .notBlankCheck("codeModelLink", req.getCodeModelLink())
                .notBlankCheck("codeModelImgUrl", req.getCodeModelImgUrl())
                .checkException();
        return ResponseResult.result(codeModelService.saveCodeModel(req));
    }

    @RequestMapping(value = "/removeCodeModel")
    @ApiModelProperty(value = "删除码模板", notes = "返回码模板删除信息")
    public ResponseResult<CodeModelVo> removeCodeModel(@RequestBody CodeModelReqVo req) {
        CheckerHelper.newInstance()
                .notBlankCheck("codeModelId", req.getCodeModelId())
                .checkException();
        codeModelService.removeCodeModel(req);
        return ResponseResult.resultAllowNull(null);
    }


}
